/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.multiqc;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.multiqc.InputPreprocessor;
import fr.ens.biologie.genomique.eoulsan.modules.multiqc.InputPreprocessorService;
import fr.ens.biologie.genomique.eoulsan.requirements.DockerRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.PathRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanDockerManager;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import fr.ens.biologie.genomique.kenetre.util.Version;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import fr.ens.biologie.genomique.kenetre.util.process.SystemSimpleProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@LocalOnly
public class MultiQCModule
extends AbstractModule {
    private static final String MODULE_NAME = "multiqc";
    private static final String MULTIQC_DOCKER_IMAGE = "ewels/multiqc:v1.7";
    private static final String MULTIQC_EXECUTABLE = "multiqc";
    private boolean dockerMode;
    private String dockerImage = "ewels/multiqc:v1.7";
    private final Set<Requirement> requirements = new HashSet<Requirement>();
    private final Map<DataFormat, InputPreprocessor> formats = new HashMap<DataFormat, InputPreprocessor>();

    @Override
    public String getName() {
        return "multiqc";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        int count = 0;
        for (DataFormat format : this.formats.keySet()) {
            builder.addPort("inputport" + count++, true, format);
        }
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.MULTIQC_REPORT_HTML);
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.unmodifiableSet(this.requirements);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        String reports = "fastqc";
        block10: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "use.docker": {
                    this.dockerMode = p.getBooleanValue();
                    continue block10;
                }
                case "docker.image": {
                    this.dockerImage = p.getStringValue().trim();
                    if (!this.dockerImage.isEmpty()) continue block10;
                    Modules.badParameterValue(context, p, "The docker image name is empty");
                    continue block10;
                }
                case "reports": {
                    reports = p.getStringValue();
                    continue block10;
                }
            }
            Modules.unknownParameter(context, p);
        }
        for (InputPreprocessor ip : MultiQCModule.parseReportParameter(reports, context.getCurrentStep().getId())) {
            this.formats.put(ip.getDataFormat(), ip);
        }
        if (this.dockerMode) {
            this.requirements.add(DockerRequirement.newDockerRequirement(this.dockerImage));
        } else {
            this.requirements.add(PathRequirement.newPathRequirement("multiqc"));
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        File multiQCReportFile = context.getOutputData(DataFormats.MULTIQC_REPORT_HTML, "all").getDataFile().toFile();
        try {
            File multiQCInputDir = FileUtils.createTempDir((File)context.getLocalTempDirectory());
            for (Map.Entry<DataFormat, InputPreprocessor> e : this.formats.entrySet()) {
                for (Data d : context.getInputData(e.getKey()).getListElements()) {
                    e.getValue().preprocess(context, d, multiQCInputDir);
                }
            }
            List<String> commandLine = this.dockerMode ? this.createMultiQCReportWithDocker(this.dockerImage, multiQCInputDir, multiQCReportFile, context.getCommandName(), context.getLocalTempDirectory()) : this.createMultiQCReport(multiQCInputDir, multiQCReportFile, context.getCommandName(), context.getLocalTempDirectory());
            status.setCommandLine(String.join((CharSequence)" ", commandLine));
            new DataFile(multiQCInputDir).delete(true);
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private static Collection<InputPreprocessor> parseReportParameter(String reports, String stepId) throws EoulsanException {
        InputPreprocessorService service = InputPreprocessorService.getInstance();
        HashMap<String, InputPreprocessor> result = new HashMap<String, InputPreprocessor>();
        for (String report : GuavaCompatibility.splitToList((Splitter)Splitter.on((char)',').trimResults().omitEmptyStrings(), (CharSequence)reports.toLowerCase())) {
            if (result.containsKey(report)) continue;
            if (!service.isService(report)) {
                throw new EoulsanException("In step \"" + stepId + "\", invalid MultiQC configuration: unknown report type: " + report);
            }
            result.put(report, (InputPreprocessor)service.newService(report));
        }
        if (result.isEmpty()) {
            throw new EoulsanException("In step \"" + stepId + "\", invalid MultiQC configuration: no report selected");
        }
        return result.values();
    }

    private List<String> createMultiQCReportWithDocker(String dockerImage, File inputDirectory, File multiQCReportFile, String projectName, File temporaryDirectory) throws IOException, EoulsanException {
        DockerImageInstance process = EoulsanDockerManager.getInstance().createImageInstance(dockerImage);
        File executionDirectory = multiQCReportFile.getParentFile();
        File stdoutFile = new File(executionDirectory, "multiqc.stdout");
        File stderrFile = new File(executionDirectory, "multiqc.stderr");
        ArrayList<File> filesUsed = new ArrayList<File>();
        filesUsed.add(executionDirectory);
        filesUsed.add(temporaryDirectory);
        filesUsed.add(multiQCReportFile);
        for (File f : inputDirectory.listFiles()) {
            if (f.getName().startsWith(".")) continue;
            filesUsed.add(f);
        }
        List<String> commandLine = MultiQCModule.createCommandLine(inputDirectory, multiQCReportFile, projectName);
        int exitValue = process.execute(commandLine, executionDirectory, temporaryDirectory, stdoutFile, stderrFile, filesUsed.toArray(new File[0]));
        if (exitValue > 0) {
            throw new EoulsanException("Invalid exit code of MultiQC: " + exitValue);
        }
        return commandLine;
    }

    private List<String> createMultiQCReport(File inputDirectory, File multiQCReportFile, String projectName, File temporaryDirectory) throws IOException, EoulsanException {
        SystemSimpleProcess process = new SystemSimpleProcess();
        File executionDirectory = multiQCReportFile.getParentFile();
        File stdoutFile = new File(executionDirectory, "multiqc.stdout");
        File stderrFile = new File(executionDirectory, "multiqc.stderr");
        List<String> commandLine = MultiQCModule.createCommandLine(inputDirectory, multiQCReportFile, projectName);
        int exitValue = process.execute(commandLine, executionDirectory, temporaryDirectory, stdoutFile, stderrFile, new File[0]);
        if (exitValue > 0) {
            throw new EoulsanException("Invalid exit code of MultiQC: " + exitValue);
        }
        return commandLine;
    }

    private static List<String> createCommandLine(File inputDirectory, File multiQCReportFile, String projectName) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("multiqc");
        result.add("--title");
        result.add("Project " + projectName + " report");
        result.add("--filename");
        result.add(multiQCReportFile.getAbsolutePath());
        result.add(inputDirectory.getAbsolutePath());
        return result;
    }
}

