/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.singlecell;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.singlecell.RSingleCellExperimentCreatorModule;
import fr.ens.biologie.genomique.kenetre.bio.AnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.CellRangerExpressionMatrixWriter;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVAnnotationMatrixReader;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.Set;

@LocalOnly
public class MatrixToCellRangerMatrixModule
extends AbstractModule {
    private static final String MODULE_NAME = "matrix2cellrangermatrix";
    private boolean inputMatrices = true;
    private boolean useAdditionalAnnotation = true;
    private String featureAnnotationFieldName = "Gene name";
    private String featureAnnotationType = "Gene Expression";
    private int cellRangerMatrixFormat = 2;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        if (this.useAdditionalAnnotation) {
            builder.addPort("additionalannotation", DataFormats.ADDITIONAL_ANNOTATION_TSV);
        }
        if (this.inputMatrices) {
            builder.addPort("matrix", true, DataFormats.EXPRESSION_MATRIX_TSV);
        } else {
            builder.addPort("expression", true, DataFormats.EXPRESSION_RESULTS_TSV);
        }
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.noOutputPort();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block14: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "input.matrices": {
                    this.inputMatrices = p.getBooleanValue();
                    continue block14;
                }
                case "use.additional.annotation": {
                    this.useAdditionalAnnotation = p.getBooleanValue();
                    continue block14;
                }
                case "additional.annotation.field.name": {
                    this.featureAnnotationFieldName = p.getValue();
                    continue block14;
                }
                case "additional.annotation.type": {
                    this.featureAnnotationType = p.getValue();
                    continue block14;
                }
                case "cell.ranger.matrix.format": {
                    this.cellRangerMatrixFormat = p.getIntValueInRange(1, 2);
                    continue block14;
                }
            }
            Modules.unknownParameter(context, p);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data matrices = context.getInputData(this.inputMatrices ? DataFormats.EXPRESSION_MATRIX_TSV : DataFormats.EXPRESSION_RESULTS_TSV);
        AnnotationMatrix geneAnnotation = null;
        try {
            if (this.useAdditionalAnnotation) {
                context.getLogger().fine("Load additional annotation");
                try (TSVAnnotationMatrixReader reader = new TSVAnnotationMatrixReader(context.getInputData(DataFormats.ADDITIONAL_ANNOTATION_TSV).getDataFile().open());){
                    geneAnnotation = reader.read();
                }
            }
            ExpressionMatrix matrix = this.inputMatrices ? RSingleCellExperimentCreatorModule.mergeMatrices(matrices) : RSingleCellExperimentCreatorModule.mergeExpressionResults(matrices);
            try (CellRangerExpressionMatrixWriter writer = new CellRangerExpressionMatrixWriter(context.getStepOutputDirectory().toFile(), geneAnnotation, this.featureAnnotationFieldName, this.cellRangerMatrixFormat, this.featureAnnotationType);){
                writer.write(matrix);
            }
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }
}

