/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.singlecell;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.RModuleCommonConfiguration;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.kenetre.bio.AnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.DenseAnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.SparseExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixFormatFinderInputStream;
import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVAnnotationMatrixReader;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVAnnotationMatrixWriter;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVCountsReader;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVExpressionMatrixWriter;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@LocalOnly
public class RSingleCellExperimentCreatorModule
extends AbstractModule {
    private static final String MODULE_NAME = "rsinglecellexperimentcreator";
    private static final String R_DOCKER_IMAGE_DEFAULT = "genomicpariscentre/singlecellexperiment:3.7";
    private static final String R_SCRIPT_NAME = "sce-rds";
    private static final String R_SCRIPT_PATH = "/singlecell/sce-rds.R";
    private final Set<Requirement> requirements = new HashSet<Requirement>();
    private RExecutor executor;
    private static final char CELL_SEPARATOR = '_';
    private boolean inputMatrices = true;
    private boolean mergeMatrices = true;
    private String designPrefix = "Cell.";
    private boolean useAdditionalAnnotation = true;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.SINGLE_CELL_EXPERMIMENT_RDS);
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        if (this.useAdditionalAnnotation) {
            builder.addPort("additionalannotation", DataFormats.ADDITIONAL_ANNOTATION_TSV);
        }
        if (this.inputMatrices) {
            builder.addPort("matrix", this.mergeMatrices, DataFormats.EXPRESSION_MATRIX_TSV);
        } else {
            builder.addPort("expression", true, DataFormats.EXPRESSION_RESULTS_TSV);
        }
        return builder.create();
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.unmodifiableSet(this.requirements);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        HashSet<Parameter> parameters = new HashSet<Parameter>(stepParameters);
        this.executor = RModuleCommonConfiguration.parseRExecutorParameter(context, parameters, this.requirements, R_DOCKER_IMAGE_DEFAULT);
        block17: for (Parameter p : parameters) {
            switch (p.getName()) {
                case "use.docker": {
                    Modules.renamedParameter(context, p, "r.execution.mode", true);
                    continue block17;
                }
                case "input.matrices": {
                    this.inputMatrices = p.getBooleanValue();
                    continue block17;
                }
                case "merge.matrices": {
                    this.mergeMatrices = p.getBooleanValue();
                    continue block17;
                }
                case "design.prefix": 
                case "design.prefix.for.cell.annotation": {
                    this.designPrefix = p.getStringValue();
                    continue block17;
                }
                case "use.gene.annotation": {
                    Modules.renamedParameter(context, p, "use.additional.annotation");
                }
                case "use.additional.annotation": {
                    this.useAdditionalAnnotation = p.getBooleanValue();
                    continue block17;
                }
            }
            Modules.unknownParameter(context, p);
        }
        if (!this.inputMatrices) {
            this.mergeMatrices = true;
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            Data inputData = context.getInputData(this.inputMatrices ? DataFormats.EXPRESSION_MATRIX_TSV : DataFormats.EXPRESSION_RESULTS_TSV);
            Data rdsData = this.mergeMatrices ? context.getOutputData(DataFormats.SINGLE_CELL_EXPERMIMENT_RDS, "matrix") : context.getOutputData(DataFormats.SINGLE_CELL_EXPERMIMENT_RDS, inputData);
            File rdsFile = rdsData.getDataFile().toFile();
            File temporaryDirectory = context.getLocalTempDirectory();
            File outputDir = context.getStepOutputDirectory().toFile();
            File matrixFile = new File(outputDir, "matrix-" + rdsData.getName() + ".tsv");
            File featuresFile = this.useAdditionalAnnotation ? new File(outputDir, "features-" + rdsData.getName() + ".tsv") : null;
            File cellsFile = this.designPrefix.isEmpty() ? null : new File(outputDir, "cells-" + rdsData.getName() + ".tsv");
            boolean saveRScript = context.getSettings().isSaveRscripts();
            this.createRInputFiles(context, inputData, matrixFile, featuresFile, cellsFile);
            this.createRDS(matrixFile, cellsFile, featuresFile, rdsFile, temporaryDirectory, saveRScript, context.getStepOutputDirectory(), "sce-rds-" + rdsData.getName());
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private void createRInputFiles(TaskContext context, Data matrices, File matrixFile, File featuresFile, File cellsFile) throws IOException {
        AnnotationMatrix featureAnnotations = null;
        AnnotationMatrix cellAnnotations = null;
        context.getLogger().fine("Load matrix");
        ExpressionMatrix matrix = this.createMatrix(matrices);
        if (featuresFile != null) {
            context.getLogger().fine("Load additional annotation");
            try (TSVAnnotationMatrixReader reader = new TSVAnnotationMatrixReader(context.getInputData(DataFormats.ADDITIONAL_ANNOTATION_TSV).getDataFile().open());){
                featureAnnotations = reader.read();
            }
            context.getLogger().fine("Filter features annotation");
            featureAnnotations.retainRows((Collection)matrix.getRowNames());
        }
        if (cellsFile != null) {
            context.getLogger().fine("Get cell annotation");
            cellAnnotations = RSingleCellExperimentCreatorModule.getCellAnnotation(matrices, context.getWorkflow().getDesign(), this.designPrefix);
        }
        if (this.inputMatrices && cellAnnotations != null) {
            context.getLogger().fine("Duplicate cell annotation");
            RSingleCellExperimentCreatorModule.duplicateCellAnnotation(cellAnnotations, matrix.getColumnNames());
        }
        context.getLogger().fine("Save matrix");
        try (TSVExpressionMatrixWriter writer = new TSVExpressionMatrixWriter(matrixFile);){
            writer.write(matrix);
        }
        if (featureAnnotations != null) {
            context.getLogger().fine("Save feature annotations");
            writer = new TSVAnnotationMatrixWriter(featuresFile);
            try {
                writer.write(featureAnnotations, (Collection)matrix.getRowNames());
            }
            finally {
                writer.close();
            }
        }
        if (cellAnnotations != null) {
            context.getLogger().fine("Save cell annotations");
            writer = new TSVAnnotationMatrixWriter(cellsFile);
            try {
                writer.write(cellAnnotations, (Collection)matrix.getColumnNames());
            }
            finally {
                writer.close();
            }
        }
    }

    private ExpressionMatrix createMatrix(Data matrices) throws IOException {
        if (this.inputMatrices) {
            if (this.mergeMatrices) {
                return RSingleCellExperimentCreatorModule.mergeMatrices(matrices);
            }
            return RSingleCellExperimentCreatorModule.loadMatrix(matrices, null);
        }
        return RSingleCellExperimentCreatorModule.mergeExpressionResults(matrices);
    }

    static ExpressionMatrix mergeMatrices(Data matrices) throws IOException {
        Objects.requireNonNull(matrices, "matrices argument cannot be null");
        SparseExpressionMatrix result = new SparseExpressionMatrix();
        for (Data matrixData : matrices.getListElements()) {
            RSingleCellExperimentCreatorModule.loadMatrix(matrixData, (ExpressionMatrix)result);
        }
        return result;
    }

    private static ExpressionMatrix loadMatrix(Data matrixData, ExpressionMatrix resultMatrix) throws IOException {
        try (ExpressionMatrixFormatFinderInputStream in = new ExpressionMatrixFormatFinderInputStream(matrixData.getDataFile().open());
             ExpressionMatrixReader reader = in.getExpressionMatrixReader();){
            String sampleName = matrixData.getName();
            HashSet existingColumnNames = resultMatrix == null ? Collections.emptySet() : new HashSet(resultMatrix.getColumnNames());
            ExpressionMatrix loadedMatrix = reader.read((ExpressionMatrix)(resultMatrix == null ? new SparseExpressionMatrix() : resultMatrix));
            for (String colName : loadedMatrix.getColumnNames()) {
                if (existingColumnNames.contains(colName)) continue;
                String newColName = sampleName + "_" + colName;
                loadedMatrix.renameColumn(colName, newColName);
            }
            if (resultMatrix == null) {
                ExpressionMatrix expressionMatrix = loadedMatrix;
                return expressionMatrix;
            }
        }
        return resultMatrix;
    }

    static ExpressionMatrix mergeExpressionResults(Data matrices) throws IOException {
        Objects.requireNonNull(matrices, "matrices argument cannot be null");
        SparseExpressionMatrix result = new SparseExpressionMatrix();
        for (Data matrixData : matrices.getListElements()) {
            String sampleName = matrixData.getName();
            try (TSVCountsReader reader = new TSVCountsReader(matrixData.getDataFile().open());){
                for (Map.Entry e : reader.read().entrySet()) {
                    result.setValue((String)e.getKey(), sampleName, (double)((Integer)e.getValue()).intValue());
                }
            }
        }
        return result;
    }

    private static AnnotationMatrix getCellAnnotation(Data matrices, Design design, String prefix) {
        DenseAnnotationMatrix result = new DenseAnnotationMatrix();
        for (Data d : matrices.getListElements()) {
            for (String key : d.getMetadata().keySet()) {
                if (!key.startsWith(prefix)) continue;
                result.setValue(d.getName(), key.substring(prefix.length()), (Object)d.getMetadata().get(key));
            }
        }
        for (Data d : matrices.getListElements()) {
            if (result.containsRow(d.getName()) || !design.containsSample(d.getName())) continue;
            Sample s = design.getSample(d.getName());
            for (String key : s.getMetadata().keySet()) {
                if (!key.startsWith(prefix)) continue;
                result.setValue(d.getName(), key.substring(prefix.length()), (Object)d.getMetadata().get(key));
            }
        }
        return result;
    }

    private static void duplicateCellAnnotation(AnnotationMatrix cellAnnotation, Collection<String> cellUMI) {
        for (String rowName : cellAnnotation.getRowNames()) {
            for (String cellId : cellUMI) {
                if (!cellId.startsWith(rowName + "_")) continue;
                for (String colName : cellAnnotation.getColumnNames()) {
                    cellAnnotation.setValue(cellId, colName, (Object)((String)cellAnnotation.getValue(rowName, colName)));
                }
            }
        }
        cellAnnotation.retainRows(cellUMI);
    }

    private void createRDS(File matrixFile, File cellsFile, File featuresFile, File rdsFile, File temporaryDirectory, boolean saveRScript, DataFile RExecutionDirectory, String scriptName) throws IOException {
        this.executor.openConnection();
        this.executor.putInputFile(new DataFile(matrixFile));
        if (cellsFile != null) {
            this.executor.putInputFile(new DataFile(cellsFile));
        }
        if (featuresFile != null) {
            this.executor.putInputFile(new DataFile(featuresFile));
        }
        String rScriptSource = RSingleCellExperimentCreatorModule.readFromJar(R_SCRIPT_PATH);
        this.executor.executeRScript(rScriptSource, false, null, saveRScript, scriptName, RExecutionDirectory, RSingleCellExperimentCreatorModule.createCommandLineArguments(matrixFile, cellsFile, featuresFile, rdsFile));
        this.executor.removeInputFiles();
        this.executor.getOutputFiles();
        this.executor.closeConnection();
    }

    private static String readFromJar(String filePathInJar) throws IOException {
        InputStream is = RSingleCellExperimentCreatorModule.class.getResourceAsStream(filePathInJar);
        StringBuilder sb = new StringBuilder();
        String line = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private static String[] createCommandLineArguments(File matrixFile, File cellsFile, File featuresFile, File rdsFile) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(matrixFile.getName());
        result.add(rdsFile.getName());
        if (cellsFile == null) {
            result.add("FALSE");
        } else {
            result.add("TRUE");
            result.add(cellsFile.getName());
        }
        if (featuresFile == null) {
            result.add("FALSE");
        } else {
            result.add("TRUE");
            result.add(featuresFile.getName());
        }
        return result.toArray(new String[0]);
    }
}

