/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.requirements;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractRequirement
implements Requirement {
    public static final String NAME_PARAMETER = "name";
    protected static final String OPTIONAL_PARAMETER = "optional";
    protected static final String INSTALLABLE_PARAMETER = "installable";
    private boolean optional;
    private boolean installable;

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isInstallable() {
        return this.installable;
    }

    protected void setOptionnal(boolean optional) {
        this.optional = optional;
    }

    protected void setInstallable(boolean installable) {
        this.installable = installable;
    }

    @Override
    public Set<Parameter> getParameters() {
        LinkedHashSet<Parameter> result = new LinkedHashSet<Parameter>();
        result.add(new Parameter(NAME_PARAMETER, this.getName()));
        result.add(new Parameter(OPTIONAL_PARAMETER, "" + this.isOptional()));
        result.add(new Parameter(INSTALLABLE_PARAMETER, "" + this.isInstallable()));
        return result;
    }

    @Override
    public void configure(Set<Parameter> parameters) throws EoulsanException {
        Objects.requireNonNull(parameters, "parameter argument cannot be null");
        block10: for (Parameter p : parameters) {
            switch (p.getName()) {
                case "name": {
                    continue block10;
                }
                case "optional": {
                    this.setOptionnal(p.getBooleanValue());
                    continue block10;
                }
                case "installable": {
                    this.setInstallable(p.getBooleanValue());
                    continue block10;
                }
            }
            throw new EoulsanException("Unknown requirement parameter: " + p.getName());
        }
    }
}

