/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.requirements;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Progress;
import fr.ens.biologie.genomique.eoulsan.requirements.AbstractRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanDockerManager;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DockerRequirement
extends AbstractRequirement {
    public static final String REQUIREMENT_NAME = "docker";
    private static final String DOCKER_IMAGE_PARAMETER = "docker.image";
    private String dockerImage;

    @Override
    public String getName() {
        return REQUIREMENT_NAME;
    }

    @Override
    public Set<Parameter> getParameters() {
        Set<Parameter> result = super.getParameters();
        result.add(new Parameter(DOCKER_IMAGE_PARAMETER, this.dockerImage));
        return Collections.unmodifiableSet(result);
    }

    @Override
    public void configure(Set<Parameter> parameters) throws EoulsanException {
        block6: for (Parameter p : parameters) {
            switch (p.getName()) {
                case "docker.image": {
                    this.dockerImage = p.getValue();
                    continue block6;
                }
            }
            super.configure(Collections.singleton(p));
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            return EoulsanDockerManager.getInstance().listImageTags().contains(this.dockerImage);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void install(Progress progress) throws EoulsanException {
        try {
            DockerImageInstance connnection = EoulsanDockerManager.getInstance().createImageInstance(this.dockerImage);
            connnection.pullImageIfNotExists(progress::setProgress);
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
        if (!this.isAvailable()) {
            throw new EoulsanException("Unable to to pull Docker image: " + this.dockerImage);
        }
    }

    public static Requirement newDockerRequirement(String dockerImage) throws EoulsanException {
        return DockerRequirement.newDockerRequirement(dockerImage, false);
    }

    public static Requirement newDockerRequirement(String dockerImage, boolean optional) throws EoulsanException {
        Objects.requireNonNull(dockerImage, "dockerImage argument cannot be null");
        Preconditions.checkArgument((!dockerImage.trim().isEmpty() ? 1 : 0) != 0, (Object)"dockerImage argument cannot be empty");
        DockerRequirement result = new DockerRequirement();
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        parameters.add(new Parameter("optional", "" + optional));
        parameters.add(new Parameter("installable", "true"));
        parameters.add(new Parameter(DOCKER_IMAGE_PARAMETER, dockerImage.trim()));
        result.configure(parameters);
        return result;
    }

    public String toString() {
        return "Docker image: " + this.dockerImage;
    }
}

