/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.requirements;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Progress;
import fr.ens.biologie.genomique.eoulsan.requirements.AbstractRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class PathRequirement
extends AbstractRequirement {
    public static final String REQUIREMENT_NAME = "path";
    private static final String EXECUTABLE_NAME_PARAMETER = "executable.name";
    private String executableName;

    @Override
    public String getName() {
        return REQUIREMENT_NAME;
    }

    @Override
    public void configure(Set<Parameter> parameters) throws EoulsanException {
        block6: for (Parameter p : parameters) {
            switch (p.getName()) {
                case "executable.name": {
                    this.executableName = p.getValue();
                    continue block6;
                }
            }
            super.configure(Collections.singleton(p));
        }
    }

    @Override
    public Set<Parameter> getParameters() {
        Set<Parameter> result = super.getParameters();
        result.add(new Parameter(EXECUTABLE_NAME_PARAMETER, this.executableName));
        return Collections.unmodifiableSet(result);
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.searchExecutableInPATH((String)this.executableName) != null;
    }

    @Override
    public void install(Progress progress) throws EoulsanException {
    }

    public static Requirement newPathRequirement(String executableName) {
        return PathRequirement.newPathRequirement(executableName, false);
    }

    public static Requirement newPathRequirement(String executableName, boolean optional) {
        Objects.requireNonNull(executableName, "executableName argument cannot be null");
        Preconditions.checkArgument((!executableName.trim().isEmpty() ? 1 : 0) != 0, (Object)"executableName argument cannot be empty");
        PathRequirement result = new PathRequirement();
        result.executableName = executableName.trim();
        result.setInstallable(false);
        result.setOptionnal(optional);
        return result;
    }

    public String toString() {
        return "Executable in PATH: " + this.executableName;
    }
}

