/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.splitermergers;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Merger;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;

public class BAMMerger
implements Merger {
    @Override
    public DataFormat getFormat() {
        return DataFormats.MAPPER_RESULTS_BAM;
    }

    @Override
    public void configure(Set<Parameter> conf) throws EoulsanException {
        Iterator<Parameter> iterator = conf.iterator();
        if (iterator.hasNext()) {
            Parameter p = iterator.next();
            throw new EoulsanException("Unknown parameter for " + this.getFormat().getName() + " merger: " + p.getName());
        }
    }

    @Override
    public void merge(Iterator<DataFile> inFileIterator, DataFile outFile) throws IOException {
        File tmpDir = EoulsanRuntime.getRuntime().getTempDirectory();
        SAMFileWriter outputSam = null;
        while (inFileIterator.hasNext()) {
            DataFile inFile = inFileIterator.next();
            EoulsanLogger.getLogger().info("Merge " + inFile.getName() + " to " + outFile.getName());
            SamReader inputSam = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inFile.open()));
            if (outputSam == null) {
                outputSam = new SAMFileWriterFactory().setTempDirectory(tmpDir).makeBAMWriter(inputSam.getFileHeader(), false, outFile.create());
            }
            for (SAMRecord samRecord : inputSam) {
                outputSam.addAlignment(samRecord);
            }
            inputSam.close();
        }
        outputSam.close();
    }
}

