/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.splitermergers;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Merger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ExpressionMerger
implements Merger {
    @Override
    public DataFormat getFormat() {
        return DataFormats.EXPRESSION_RESULTS_TSV;
    }

    @Override
    public void configure(Set<Parameter> conf) throws EoulsanException {
        Iterator<Parameter> iterator = conf.iterator();
        if (iterator.hasNext()) {
            Parameter p = iterator.next();
            throw new EoulsanException("Unknown parameter for " + this.getFormat().getName() + " merger: " + p.getName());
        }
    }

    @Override
    public void merge(Iterator<DataFile> inFileIterator, DataFile outFile) throws IOException {
        HashMultiset counts = HashMultiset.create();
        HashSet<String> emptyCounts = new HashSet<String>();
        while (inFileIterator.hasNext()) {
            DataFile inFile = inFileIterator.next();
            EoulsanLogger.getLogger().info("Merge " + inFile.getName() + " to " + outFile.getName());
            boolean first = true;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inFile.open()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    int tabPos = line.indexOf(9);
                    if (tabPos == -1) continue;
                    try {
                        String id = line.substring(0, tabPos).trim();
                        int count = Integer.parseInt(line.substring(tabPos).trim());
                        if (count == 0) {
                            emptyCounts.add(id);
                        }
                        counts.add((Object)id, count);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(outFile.create());){
            writer.write("Id\tCount\n");
            for (Multiset.Entry e : counts.entrySet()) {
                String id = (String)e.getElement();
                emptyCounts.remove(id);
                writer.write(id + "\t" + e.getCount() + "\n");
            }
            for (String id : emptyCounts) {
                writer.write(id + "\t0\n");
            }
        }
    }
}

