/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.splitermergers;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;

public class ExpressionSplitter
implements Splitter {
    private static final int DEFAULT_SPLIT_MAX_ENTRIES = 10000;
    static final String EXPRESSION_FILE_HEADER = "Id\tCount\n";
    private int splitMaxEntries = 10000;

    @Override
    public DataFormat getFormat() {
        return DataFormats.EXPRESSION_RESULTS_TSV;
    }

    @Override
    public void configure(Set<Parameter> conf) throws EoulsanException {
        block6: for (Parameter p : conf) {
            switch (p.getName()) {
                case "max.entries": {
                    this.splitMaxEntries = p.getIntValueGreaterOrEqualsTo(1);
                    continue block6;
                }
            }
            throw new EoulsanException("Unknown parameter for " + this.getFormat().getName() + " splitter: " + p.getName());
        }
    }

    @Override
    public void split(DataFile inFile, Iterator<DataFile> outFileIterator) throws IOException {
        int max = this.splitMaxEntries;
        int readCount = 0;
        Writer writer = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inFile.open()));){
            String line = null;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (first) {
                    first = false;
                    continue;
                }
                if (readCount % max == 0) {
                    if (writer != null) {
                        writer.close();
                    }
                    writer = new OutputStreamWriter(outFileIterator.next().create());
                    writer.write(EXPRESSION_FILE_HEADER);
                }
                writer.write(line + "\n");
                ++readCount;
            }
            reader.close();
            if (writer != null) {
                writer.close();
            }
        }
    }
}

