/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.splitermergers;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Merger;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class FastqMerger
implements Merger {
    @Override
    public DataFormat getFormat() {
        return DataFormats.READS_FASTQ;
    }

    @Override
    public void configure(Set<Parameter> conf) throws EoulsanException {
        Iterator<Parameter> iterator = conf.iterator();
        if (iterator.hasNext()) {
            Parameter p = iterator.next();
            throw new EoulsanException("Unknown parameter for " + this.getFormat().getName() + " merger: " + p.getName());
        }
    }

    @Override
    public void merge(Iterator<DataFile> inDataFileIterator, DataFile outFile) throws IOException {
        FastqWriter writer = new FastqWriter(outFile.create());
        while (inDataFileIterator.hasNext()) {
            DataFile inFile = inDataFileIterator.next();
            EoulsanLogger.getLogger().info("Merge " + inFile.getName() + " to " + outFile.getName());
            FastqReader reader = new FastqReader(inFile.open());
            for (ReadSequence read : reader) {
                writer.write(read);
            }
            reader.close();
            try {
                reader.throwException();
            }
            catch (BadBioEntryException e) {
                throw new IOException(e);
            }
        }
        writer.close();
    }
}

