/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.ui;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import fr.ens.biologie.genomique.eoulsan.ui.AbstractUI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BasicUI
extends AbstractUI {
    private Workflow workflow;
    private final Map<Step, Double> steps = new HashMap<Step, Double>();
    private final Map<Step, Step.StepState> stepState = new HashMap<Step, Step.StepState>();
    private int lastMessageLength = 0;

    @Override
    public String getName() {
        return "basic";
    }

    @Override
    public void init(Workflow workflow) {
        Objects.requireNonNull(workflow, "workflow is null");
        this.workflow = workflow;
        this.searchSteps();
    }

    @Override
    public void notifyStepState(Step step, Step.StepState stepState) {
        Preconditions.checkState((this.workflow != null ? 1 : 0) != 0, (Object)"The UI has not been initialized");
        if (step == null || stepState == null || step.getWorkflow() != this.workflow) {
            return;
        }
        this.stepState.put(step, stepState);
        if (stepState == Step.StepState.WORKING) {
            this.notifyStepState(step, 0, 0, 0.0);
        }
    }

    @Override
    public void notifyStepState(Step step, int contextId, String contextName, double progress) {
        Preconditions.checkState((this.workflow != null ? 1 : 0) != 0, (Object)"The UI has not been initialized");
    }

    @Override
    public void notifyStepState(Step step, int terminatedTasks, int submittedTasks, double progress) {
        Preconditions.checkState((this.workflow != null ? 1 : 0) != 0, (Object)"The UI has not been initialized");
        if (!this.isInteractiveMode() || step == null || step.getWorkflow() != this.workflow || this.stepState.get(step) != Step.StepState.WORKING || !this.steps.containsKey(step)) {
            return;
        }
        double globalProgress = this.computeGlobalProgress(step, progress);
        if (globalProgress == 0.0 && this.lastMessageLength == 0) {
            System.out.println(Globals.WELCOME_MSG);
        }
        String msg = String.format("%.0f%% workflow done (currently process step %s #%d, %.0f%% done)", globalProgress * 100.0, step.getId(), step.getNumber(), progress * 100.0);
        System.out.print(Strings.repeat((String)"\r", (int)this.lastMessageLength));
        System.out.print(Strings.repeat((String)" ", (int)this.lastMessageLength));
        System.out.print(Strings.repeat((String)"\r", (int)this.lastMessageLength));
        this.lastMessageLength = msg.length();
        System.out.print(msg);
        if (globalProgress == 1.0) {
            System.out.println();
        }
        System.out.flush();
    }

    @Override
    public void notifyStepState(Step step, String note) {
        Preconditions.checkState((this.workflow != null ? 1 : 0) != 0, (Object)"The UI has not been initialized");
        if (step == null || step.getWorkflow() != this.workflow) {
            return;
        }
        System.out.print("Step " + step.getId() + " " + this.stepState.get(step).toString() + " note: " + note);
    }

    @Override
    public void notifyWorkflowSuccess(boolean success, String message) {
    }

    @Override
    public void notifyTaskSubmitted(Step step, int contextId) {
    }

    @Override
    public void notifyTaskRunning(Step step, int contextId) {
    }

    @Override
    public void notifyTaskDone(Step step, int contextId) {
    }

    private void searchSteps() {
        for (Step step : this.workflow.getSteps()) {
            if (step == null) continue;
            switch (step.getType()) {
                case CHECKER_STEP: 
                case GENERATOR_STEP: 
                case STANDARD_STEP: {
                    if (step.isSkip()) break;
                    this.steps.put(step, 0.0);
                    break;
                }
            }
        }
    }

    private double computeGlobalProgress(Step step, double progress) {
        if (!this.steps.containsKey(step)) {
            return -1.0;
        }
        this.steps.put(step, progress);
        double sum = 0.0;
        for (double p : this.steps.values()) {
            sum += p;
        }
        return sum / (double)this.steps.size();
    }
}

