/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.util.AbstractResourceLoader;
import fr.ens.biologie.genomique.kenetre.util.ServiceListLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.ServiceConfigurationError;

public abstract class ClassPathResourceLoader<S>
extends AbstractResourceLoader<S> {
    private final Class<S> clazz;
    private final String resourceBasePath;

    @Override
    protected InputStream getResourceAsStream(String resourcePath) throws IOException {
        Objects.requireNonNull(resourcePath, "resourcePath argument cannot be null");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream(resourcePath);
    }

    @Override
    public void reload() {
        try {
            for (String filename : ServiceListLoader.load((String)this.clazz.getName())) {
                String resourcePath = this.resourceBasePath + filename;
                EoulsanLogger.getLogger().fine("Try to load " + this.clazz.getSimpleName() + " from " + filename + " resource");
                Object resource = this.load(this.getResourceAsStream(resourcePath), resourcePath);
                if (resource == null) {
                    throw new EoulsanException("Cannot load resource: " + resourcePath);
                }
                String resourceName = this.getResourceName(resource);
                if (resourceName == null) {
                    throw new EoulsanException("Cannot get resource name for resource: " + resource);
                }
                this.addResource(resourceName, resourcePath);
            }
        }
        catch (EoulsanException | IOException e) {
            throw new ServiceConfigurationError("Unable to load resource", e);
        }
    }

    public ClassPathResourceLoader(Class<S> clazz, String resourcePath) {
        Objects.requireNonNull(clazz, "clazz argument cannot be null");
        Objects.requireNonNull(resourcePath, "resourcePath argument cannot be null");
        this.clazz = clazz;
        this.resourceBasePath = resourcePath;
    }
}

