/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.hadoop;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class HadoopReporter
implements Reporter {
    private final TaskInputOutputContext context;
    private final Counters counters;

    public void incrCounter(String counterGroup, String counterName, long amount) {
        if (this.context != null) {
            this.context.getCounter(counterGroup, counterName).increment(amount);
        } else {
            ((CounterGroup)this.counters.getGroup(counterGroup)).findCounter(counterName).increment(amount);
        }
    }

    public long getCounterValue(String counterGroup, String counterName) {
        if (this.context != null) {
            throw new UnsupportedOperationException();
        }
        return this.counters.findCounter(counterGroup, counterName).getValue();
    }

    public Set<String> getCounterGroups() {
        if (this.context != null) {
            throw new UnsupportedOperationException();
        }
        return Sets.newHashSet((Iterable)this.counters.getGroupNames());
    }

    public Set<String> getCounterNames(String group) {
        if (this.context != null) {
            throw new UnsupportedOperationException();
        }
        HashSet<String> result = new HashSet<String>();
        for (Counter c : (CounterGroup)this.counters.getGroup(group)) {
            result.add(c.getName());
        }
        return result;
    }

    public HadoopReporter(TaskInputOutputContext context) {
        Objects.requireNonNull(context, "context is null");
        this.counters = null;
        this.context = context;
    }

    public HadoopReporter(Counters counters) {
        Objects.requireNonNull(counters, "counters is null");
        this.counters = counters;
        this.context = null;
    }
}

