/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.hadoop;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopJobEmergencyStopTask;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopReporter;
import java.io.IOException;
import org.apache.hadoop.mapreduce.Job;

public final class MapReduceUtils {
    private static final int COMPLETION_POLL_INTERVAL = 5000;
    private static final int MAX_CONNECTION_TRY_TO_JOB_TRACK = 12;

    public static void submitAndWaitForJob(Job job, String jobDescription, int waitTimeInMillis, TaskStatus status, String counterGroup) throws EoulsanException {
        if (job == null) {
            throw new NullPointerException("The job is null");
        }
        if (jobDescription == null) {
            throw new NullPointerException("The jobDescription is null");
        }
        try {
            status.setDescription(job.getJobName());
            job.submit();
            HadoopJobEmergencyStopTask.addHadoopJobEmergencyStopTask(job);
            MapReduceUtils.waitForCompletion(job, 12);
            HadoopJobEmergencyStopTask.removeHadoopJobEmergencyStopTask(job);
            if (!job.isSuccessful()) {
                status.setProgressMessage("FAILED");
                throw new EoulsanException("Fail of the Hadoop job: " + job.getJobFile());
            }
            status.setCounters(new HadoopReporter(job.getCounters()), counterGroup);
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            throw new EoulsanException(e);
        }
    }

    public static void waitForCompletion(Job job, int maxTry) throws IOException {
        if (job == null) {
            throw new NullPointerException("The job is null");
        }
        MapReduceUtils.waitForCompletion(job, maxTry, 0);
    }

    private static void waitForCompletion(Job job, int maxTry, int failedTry) throws IOException {
        try {
            while (!job.isComplete()) {
                failedTry = 0;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Fail to check if Hadoop Job (" + job.getJobName() + ") is completed, " + ++failedTry + "/" + maxTry + " trys: " + e.getMessage());
            if (failedTry >= maxTry) {
                throw new IOException(e);
            }
            MapReduceUtils.waitForCompletion(job, maxTry, failedTry);
        }
    }

    private MapReduceUtils() {
    }
}

