/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.hadoop;

import fr.ens.biologie.genomique.eoulsan.io.FileCharsets;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionOutputStream;

public final class PathUtils {
    public static InputStream createInputStream(Path path, Configuration conf) throws IOException {
        if (path == null) {
            throw new NullPointerException("Path to create is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(conf);
        if (fs == null) {
            throw new IOException("Unable to create InputSteam, The FileSystem is null");
        }
        return fs.open(path);
    }

    public static OutputStream createOutputStream(Path path, Configuration conf) throws IOException {
        if (path == null) {
            throw new NullPointerException("Path to create is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(conf);
        if (fs == null) {
            throw new IOException("Unable to create InputSteam, The FileSystem is null");
        }
        return fs.create(path);
    }

    public static long getSize(Path path, Configuration conf) throws IOException {
        if (path == null) {
            throw new NullPointerException("Path to create is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(conf);
        if (fs == null) {
            throw new IOException("Unable to create InputSteam, The FileSystem is null");
        }
        return fs.getFileStatus(path).getLen();
    }

    public static boolean copyFromPathToLocalFile(Path srcPath, File destFile, Configuration conf) throws IOException {
        return PathUtils.copyFromPathToLocalFile(srcPath, destFile, false, conf);
    }

    public static boolean copyFromPathToLocalFile(Path srcPath, File destFile, boolean removeOriginalFile, Configuration conf) throws IOException {
        if (srcPath == null) {
            throw new NullPointerException("The source path is null");
        }
        if (destFile == null) {
            throw new NullPointerException("The destination file is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = FileSystem.get((URI)srcPath.toUri(), (Configuration)conf);
        return FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)destFile, (boolean)removeOriginalFile, (Configuration)conf);
    }

    public static boolean copyLocalFileToPath(File srcFile, Path destPath, Configuration conf) throws IOException {
        return PathUtils.copyLocalFileToPath(srcFile, destPath, false, conf);
    }

    public static boolean copyLocalFileToPath(File srcFile, Path destPath, boolean removeSrcFile, Configuration conf) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("The source file is null");
        }
        if (destPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        return FileUtil.copy((File)srcFile, (FileSystem)FileSystem.get((URI)destPath.toUri(), (Configuration)conf), (Path)destPath, (boolean)removeSrcFile, (Configuration)conf);
    }

    public static long copyInputStreamToPath(InputStream is, Path destPath, Configuration conf) throws IOException {
        if (is == null) {
            throw new NullPointerException("The input stream is null");
        }
        if (destPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = FileSystem.get((URI)destPath.toUri(), (Configuration)conf);
        FSDataOutputStream os = fs.create(destPath);
        return FileUtils.copy((InputStream)is, (OutputStream)os);
    }

    public static boolean copyAndCompressLocalFileToPath(File srcFile, Path destPath, Configuration conf) throws IOException {
        return PathUtils.copyAndCompressLocalFileToPath(srcFile, destPath, false, conf);
    }

    public static boolean copyAndCompressLocalFileToPath(File srcFile, Path destPath, boolean removeSrcFile, Configuration conf) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("The source file is null");
        }
        if (destPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        return PathUtils.copyAndCompressInputStreamToPath(FileUtils.createInputStream((File)srcFile), destPath, conf);
    }

    public static boolean copyAndCompressInputStreamToPath(InputStream is, Path destPath, Configuration conf) throws IOException {
        if (is == null) {
            throw new NullPointerException("The input stream is null");
        }
        if (destPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = FileSystem.get((URI)destPath.toUri(), (Configuration)conf);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodec(destPath);
        if (codec == null) {
            throw new IOException("No codec found for: " + destPath);
        }
        CompressionOutputStream os = codec.createOutputStream((OutputStream)fs.create(destPath));
        FileUtils.copy((InputStream)is, (OutputStream)os);
        return true;
    }

    public static void unZipPathToLocalFile(Path path, File outputDir, Configuration conf) throws IOException {
        PathUtils.unZipPathToLocalFile(path, outputDir, false, conf);
    }

    public static void unZipPathToLocalFile(Path srcPath, File outputDir, boolean removeOriginalZipFile, Configuration conf) throws IOException {
        if (srcPath == null) {
            throw new NullPointerException("The source path is null");
        }
        if (outputDir == null) {
            throw new NullPointerException("The destination directory file is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        File tmpZipFile = FileUtils.createTempFile((String)"", (String)".zip");
        PathUtils.copyFromPathToLocalFile(srcPath, tmpZipFile, removeOriginalZipFile, conf);
        FileUtils.unzip((File)tmpZipFile, (File)outputDir);
        if (!tmpZipFile.delete()) {
            throw new IOException("Can't remove temporary zip file: " + tmpZipFile.getAbsolutePath());
        }
    }

    public static boolean fullyDelete(Path path, Configuration conf) throws IOException {
        if (path == null) {
            throw new NullPointerException("Path to delete is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration object is null");
        }
        FileSystem fs = path.getFileSystem(conf);
        if (fs == null) {
            throw new IOException("Unable to delete path, The FileSystem is null");
        }
        return fs.delete(path, true);
    }

    public static void copyMerge(Path srcPath, Path destPath, Configuration conf) throws IOException {
        PathUtils.copyMerge(srcPath, destPath, false, conf, null);
    }

    public static void copyMerge(Path srcPath, Path destPath, boolean deleteSource, Configuration conf) throws IOException {
        PathUtils.copyMerge(srcPath, destPath, deleteSource, conf, null);
    }

    public static void copyMerge(Path srcPath, Path destPath, boolean deleteSource, Configuration conf, String addString) throws IOException {
        if (srcPath == null) {
            throw new NullPointerException("The source path is null.");
        }
        if (destPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null");
        }
        FileSystem srcFs = srcPath.getFileSystem(conf);
        FileSystem destFs = destPath.getFileSystem(conf);
        FileUtil.copyMerge((FileSystem)srcFs, (Path)srcPath, (FileSystem)destFs, (Path)destPath, (boolean)deleteSource, (Configuration)conf, (String)addString);
    }

    public static Path newPathWithOtherExtension(Path path, String extension) {
        if (path == null) {
            throw new NullPointerException("Path is null");
        }
        if (extension == null) {
            throw new NullPointerException("Extension is null");
        }
        return new Path(path.getParent(), StringUtils.basename((String)path.getName()) + extension);
    }

    public static List<Path> listPathsByPrefix(Path dir, String prefix, Configuration conf) throws IOException {
        return PathUtils.listPathsByPrefix(dir, prefix, false, conf);
    }

    public static List<Path> listPathsByPrefix(Path dir, String prefix, boolean allowCompressedExtension, Configuration conf) throws IOException {
        if (dir == null) {
            throw new NullPointerException("Directory path is null");
        }
        if (prefix == null) {
            throw new NullPointerException("Prefix is null");
        }
        if (conf == null) {
            throw new NullPointerException("Configuration is null");
        }
        FileSystem fs = dir.getFileSystem(conf);
        if (!fs.getFileStatus(dir).isDirectory()) {
            throw new IOException("Directory path is not a directory: " + dir);
        }
        FileStatus[] filesStatus = fs.listStatus(dir, (PathFilter)new PrefixPathFilter(prefix, allowCompressedExtension));
        if (filesStatus == null) {
            return Collections.emptyList();
        }
        ArrayList<Path> result = new ArrayList<Path>(filesStatus.length);
        for (FileStatus fst : filesStatus) {
            result.add(fst.getPath());
        }
        return result;
    }

    public static List<Path> listPathsBySuffix(Path dir, String suffix, Configuration conf) throws IOException {
        return PathUtils.listPathsBySuffix(dir, suffix, false, conf);
    }

    public static List<Path> listPathsBySuffix(Path dir, String suffix, boolean allowCompressedExtension, Configuration conf) throws IOException {
        if (dir == null) {
            throw new NullPointerException("Directory path is null");
        }
        if (suffix == null) {
            throw new NullPointerException("Suffix is null");
        }
        if (conf == null) {
            throw new NullPointerException("Configuration is null");
        }
        FileSystem fs = dir.getFileSystem(conf);
        if (!fs.getFileStatus(dir).isDirectory()) {
            throw new IOException("Directory path is not a directory: " + dir);
        }
        FileStatus[] filesStatus = fs.listStatus(dir, (PathFilter)new SuffixPathFilter(suffix, allowCompressedExtension));
        if (filesStatus == null) {
            return Collections.emptyList();
        }
        ArrayList<Path> result = new ArrayList<Path>(filesStatus.length);
        for (FileStatus fst : filesStatus) {
            result.add(fst.getPath());
        }
        return result;
    }

    public static Path createTempPath(Path directory, String prefix, String suffix, Configuration conf) throws IOException {
        String filename;
        Path tempFile;
        if (directory == null) {
            throw new NullPointerException("Directory is null");
        }
        if (conf == null) {
            throw new NullPointerException("Configuration is null");
        }
        Path myDir = directory;
        String myPrefix = prefix == null ? "" : prefix;
        String mySuffix = suffix == null ? "" : suffix;
        FileSystem fs = directory.getFileSystem(conf);
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while (fs.isFile(tempFile = new Path(myDir, filename = myPrefix + UUID.randomUUID().toString() + mySuffix)));
        return tempFile;
    }

    public static boolean concat(List<Path> paths, Path dstPath, Configuration conf) throws IOException {
        return PathUtils.concat(paths, dstPath, false, true, null);
    }

    public static boolean concat(List<Path> paths, Path dstPath, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        return PathUtils.concat(paths, dstPath, deleteSource, overwrite, conf, null);
    }

    public static boolean concat(List<Path> paths, Path dstPath, boolean deleteSource, boolean overwrite, Configuration conf, String addString) throws IOException {
        if (paths == null) {
            throw new NullPointerException("The list of path to concat is null");
        }
        if (paths.size() == 0) {
            return false;
        }
        if (dstPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null.");
        }
        FileSystem srcFs = paths.get(0).getFileSystem(conf);
        FileSystem dstFs = dstPath.getFileSystem(conf);
        if (!overwrite && dstFs.exists(dstPath)) {
            throw new IOException("The output file already exists: " + dstPath);
        }
        try (FSDataOutputStream out = dstFs.create(dstPath);){
            for (Path p : paths) {
                if (srcFs.getFileStatus(p).isDirectory()) continue;
                FSDataInputStream in = srcFs.open(p);
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
                    if (addString == null) continue;
                    out.write(addString.getBytes(FileCharsets.UTF8_CHARSET));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        if (deleteSource) {
            for (Path p : paths) {
                if (srcFs.delete(p, false)) continue;
                return false;
            }
        }
        return true;
    }

    public static void checkExistingFile(Path file, Configuration conf, String msgFileType) throws IOException {
        if (msgFileType == null) {
            throw new NullPointerException("Message file type for check is null");
        }
        if (file == null) {
            throw new NullPointerException("The " + msgFileType + " is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null");
        }
        FileSystem fs = file.getFileSystem(conf);
        if (!fs.exists(file)) {
            throw new IOException("The " + msgFileType + " does not exists: " + file);
        }
    }

    public static void checkExistingDirectoryFile(Path directory, Configuration conf, String msgFileType) throws IOException {
        PathUtils.checkExistingFile(directory, conf, msgFileType);
        FileSystem fs = directory.getFileSystem(conf);
        if (!fs.getFileStatus(directory).isDirectory()) {
            throw new IOException("The " + msgFileType + " is not a directory: " + directory);
        }
    }

    public static boolean isExistingDirectoryFile(Path directory, Configuration conf) throws IOException {
        if (directory == null) {
            throw new NullPointerException("The directory is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null");
        }
        FileSystem fs = directory.getFileSystem(conf);
        try {
            return fs.getFileStatus(directory).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean isFile(Path file, Configuration conf) throws IOException {
        if (file == null) {
            throw new NullPointerException("The path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null");
        }
        FileSystem fs = file.getFileSystem(conf);
        return fs.isFile(file);
    }

    public static void checkExistingStandardFile(Path file, Configuration conf, String msgFileType) throws IOException {
        PathUtils.checkExistingFile(file, conf, msgFileType);
        FileSystem fs = file.getFileSystem(conf);
        if (!fs.isFile(file)) {
            throw new IOException("The " + msgFileType + " is  not a standard file: " + file);
        }
    }

    public static void checkExistingStandardFileOrDirectory(Path file, Configuration conf, String msgFileType) throws IOException {
        PathUtils.checkExistingDirectoryFile(file, conf, msgFileType);
        FileSystem fs = file.getFileSystem(conf);
        if (!fs.isFile(file) && !fs.getFileStatus(file).isDirectory()) {
            throw new IOException("The " + msgFileType + " is  not a standard file or a directory: " + file);
        }
    }

    public static boolean copy(Path srcPath, Path destPath, Configuration conf) throws IOException {
        return PathUtils.copy(srcPath, destPath, true, conf);
    }

    public static boolean copy(Path srcPath, Path destPath, boolean overwrite, Configuration conf) throws IOException {
        if (srcPath == null) {
            throw new NullPointerException("The source path is null.");
        }
        if (destPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null");
        }
        FileSystem srcFs = srcPath.getFileSystem(conf);
        FileSystem destFs = destPath.getFileSystem(conf);
        return FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)destFs, (Path)destPath, (boolean)false, (boolean)overwrite, (Configuration)conf);
    }

    public static boolean move(Path srcPath, Path destPath, Configuration conf) throws IOException {
        return PathUtils.move(srcPath, destPath, true, conf);
    }

    public static boolean move(Path srcPath, Path destPath, boolean overwrite, Configuration conf) throws IOException {
        if (srcPath == null) {
            throw new NullPointerException("The source path is null.");
        }
        if (destPath == null) {
            throw new NullPointerException("The destination path is null");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null");
        }
        FileSystem srcFs = srcPath.getFileSystem(conf);
        FileSystem destFs = destPath.getFileSystem(conf);
        return FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)destFs, (Path)destPath, (boolean)true, (boolean)overwrite, (Configuration)conf);
    }

    public static boolean mkdirs(Path path, Configuration conf) throws IOException {
        if (path == null) {
            throw new NullPointerException("The path of the directory to create is null.");
        }
        if (conf == null) {
            throw new NullPointerException("The configuration is null");
        }
        FileSystem fs = path.getFileSystem(conf);
        return fs.mkdirs(path);
    }

    public static boolean exists(Path path, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        return fs.exists(path);
    }

    private PathUtils() {
    }

    public static final class PrefixPathFilter
    implements PathFilter {
        private final String prefix;
        private final boolean allowCompressedFile;

        public boolean accept(Path path) {
            if (path == null) {
                return false;
            }
            String myName = this.allowCompressedFile ? StringUtils.removeCompressedExtensionFromFilename((String)path.getName()) : path.getName();
            return myName.startsWith(this.prefix);
        }

        public PrefixPathFilter(String prefix) {
            this(prefix, false);
        }

        public PrefixPathFilter(String prefix, boolean allowCompressedFile) {
            if (prefix == null) {
                throw new NullPointerException("The prefix is null");
            }
            this.prefix = prefix;
            this.allowCompressedFile = allowCompressedFile;
        }
    }

    public static final class SuffixPathFilter
    implements PathFilter {
        private final String suffix;
        private final boolean allowCompressedFile;

        public boolean accept(Path path) {
            if (path == null) {
                return false;
            }
            String myName = this.allowCompressedFile ? StringUtils.removeCompressedExtensionFromFilename((String)path.getName()) : path.getName();
            return myName.endsWith(this.suffix);
        }

        public SuffixPathFilter(String suffix) {
            this(suffix, false);
        }

        public SuffixPathFilter(String suffix, boolean allowCompressedFile) {
            if (suffix == null) {
                throw new NullPointerException("The suffix is null");
            }
            this.suffix = suffix;
            this.allowCompressedFile = allowCompressedFile;
        }
    }
}

