/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.locker;

import fr.ens.biologie.genomique.eoulsan.util.locker.DistributedLock;
import fr.ens.biologie.genomique.eoulsan.util.locker.Locker;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class DistributedLocker
implements Locker,
Watcher {
    private final DistributedLock lock;
    private final CountDownLatch connectSignal = new CountDownLatch(1);

    @Override
    public void lock() throws IOException {
        this.lock.lock();
    }

    @Override
    public void unlock() throws IOException {
        this.lock.unlock();
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.connectSignal.countDown();
        }
    }

    public DistributedLocker(String connectString, int sessionTimeout, String lockBasePath, String lockName) throws IOException {
        ZooKeeper zk = new ZooKeeper(connectString, sessionTimeout, (Watcher)this);
        try {
            this.connectSignal.await();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.lock = new DistributedLock(zk, lockBasePath + "/" + lockName);
    }
}

