/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.locker;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.eoulsan.util.locker.Locker;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Set;

public class ExecLock
implements Locker {
    private static final String LOCK_EXTENSION = ".lock";
    private static final String PID_EXTENSION = ".pid";
    private static final String PID_LOCK_EXTENSION = ".pidlock";
    private static final int pid = ExecLock.getPid();
    private final String execName;
    private final File tmpDir;
    private final File lockFile;
    private final File pidLockFile;
    private final File pidFile;
    private boolean lock;

    private static int getPid() {
        String beanName = ManagementFactory.getRuntimeMXBean().getName();
        int index = beanName.indexOf(64);
        return Integer.parseInt(beanName.substring(0, index));
    }

    @Override
    public void lock() {
        while (this.lock) {
            this.sleep(5000);
        }
        try {
            if (!this.pidFile.createNewFile()) {
                throw new IOException("Can not create pid file: " + this.pidFile.getAbsolutePath());
            }
            int count = 0;
            while (true) {
                if (count == 0) {
                    this.checkLockJVMAlive();
                }
                if (!this.lockFile.exists() && this.checkPid()) {
                    if (!this.lockFile.createNewFile()) {
                        throw new IOException("Can not create lock file: " + this.lockFile.getAbsolutePath());
                    }
                    if (!this.pidLockFile.createNewFile()) {
                        throw new IOException("Can not create pid lock file: " + this.lockFile.getAbsolutePath());
                    }
                    this.lock = true;
                    return;
                }
                if (count == 12) {
                    count = 0;
                }
                ++count;
                this.sleep(5000);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void unlock() {
        if (!this.lockFile.delete()) {
            EoulsanLogger.getLogger().warning("Can not delete lock file: " + this.lockFile.getAbsolutePath());
        }
        if (!this.pidLockFile.delete()) {
            EoulsanLogger.getLogger().warning("Can not delete pid lock file: " + this.pidLockFile.getAbsolutePath());
        }
        if (!this.pidFile.delete()) {
            EoulsanLogger.getLogger().warning("Can not delete pid file: " + this.pidFile.getAbsolutePath());
        }
        this.lock = false;
        this.sleep(10000);
    }

    private boolean checkPid() {
        File[] files = this.tmpDir.listFiles((arg0, arg1) -> arg1.startsWith(this.execName + "-") && arg1.endsWith(PID_EXTENSION));
        if (files == null) {
            return true;
        }
        Set<Integer> jvmPids = this.getJVMsPIDs();
        int oldestPid = -1;
        long oldestPidFileDate = Long.MAX_VALUE;
        for (File f : files) {
            int fPid;
            String basename = StringUtils.basename((String)f.getName());
            try {
                fPid = Integer.parseInt(basename.substring(this.execName.length() + 1));
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (!jvmPids.contains(fPid)) {
                if (f.delete()) continue;
                EoulsanLogger.getLogger().warning("Can not delete pid file: " + f.getAbsolutePath());
                continue;
            }
            if (f.lastModified() >= oldestPidFileDate) continue;
            oldestPidFileDate = f.lastModified();
            oldestPid = fPid;
        }
        return oldestPid == pid;
    }

    private Set<Integer> getJVMsPIDs() {
        return ProcessUtils.getExecutablePids("java");
    }

    private void sleep(int duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void checkLockJVMAlive() {
        File[] files = this.tmpDir.listFiles((arg0, arg1) -> arg1.startsWith(this.execName + "-") && arg1.endsWith(PID_LOCK_EXTENSION));
        if (files == null || files.length == 0) {
            if (!this.lockFile.delete()) {
                EoulsanLogger.getLogger().warning("Can not delete lock file: " + this.lockFile.getAbsolutePath());
            }
            return;
        }
        Set<Integer> jvmsPIDs = this.getJVMsPIDs();
        int count = 0;
        for (File f : files) {
            int fPid;
            String basename = StringUtils.basename((String)f.getName());
            try {
                fPid = Integer.parseInt(basename.substring(this.execName.length() + 1));
            }
            catch (NumberFormatException e) {
                if (f.delete()) continue;
                EoulsanLogger.getLogger().warning("Can not delete pid file: " + f.getAbsolutePath());
                continue;
            }
            if (jvmsPIDs.contains(fPid)) {
                ++count;
                continue;
            }
            if (f.delete()) continue;
            EoulsanLogger.getLogger().warning("Can not delete pid file: " + f.getAbsolutePath());
        }
        if (count == 0 && !this.lockFile.delete()) {
            EoulsanLogger.getLogger().warning("Can not delete lock file: " + this.lockFile.getAbsolutePath());
        }
    }

    public int getProcessesWaiting() {
        File[] files = this.tmpDir.listFiles((arg0, arg1) -> arg1.startsWith(this.execName + "-") && arg1.endsWith(PID_EXTENSION));
        if (files == null) {
            return 0;
        }
        return files.length;
    }

    public ExecLock(String execName, File tmpDir) {
        this.execName = execName;
        this.tmpDir = tmpDir;
        this.lockFile = new File(this.tmpDir, this.execName + LOCK_EXTENSION);
        this.pidLockFile = new File(this.tmpDir, this.execName + "-" + pid + PID_LOCK_EXTENSION);
        this.pidFile = new File(this.tmpDir, this.execName + "-" + pid + PID_EXTENSION);
    }

    public ExecLock(String execName) {
        this(execName, new File("/tmp"));
    }
}

