/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.locker;

import fr.ens.biologie.genomique.eoulsan.util.locker.Locker;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperLocker
implements Locker,
Watcher {
    private final ZooKeeper zk;
    private final String lockBasePath;
    private final String lockName;
    private final boolean sequentialLockName;
    private String lockPath;
    private boolean response;

    @Override
    public void lock() throws IOException {
        if (!this.response) {
            throw new IOException("Connection to Zookeeper is not alive");
        }
        try {
            Object lock;
            if (this.zk.exists(this.lockBasePath, false) == null) {
                this.zk.create(this.lockBasePath, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            this.lockPath = this.zk.create(this.lockBasePath + "/" + this.lockName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, this.sequentialLockName ? CreateMode.EPHEMERAL_SEQUENTIAL : CreateMode.EPHEMERAL);
            Object object = lock = new Object();
            synchronized (object) {
                while (true) {
                    List nodes = this.zk.getChildren(this.lockBasePath, event -> {
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                        }
                    });
                    Collections.sort(nodes);
                    if (this.lockPath.endsWith((String)nodes.get(0))) {
                        return;
                    }
                    lock.wait();
                }
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void unlock() throws IOException {
        try {
            this.zk.delete(this.lockPath, -1);
            this.lockPath = null;
            this.zk.close();
            this.response = false;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException(e);
        }
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.response = true;
        }
    }

    public ZooKeeperLocker(String connectString, int sessionTimeout, String lockBasePath, String lockName) throws IOException {
        this(connectString, sessionTimeout, lockBasePath, lockName, true);
    }

    public ZooKeeperLocker(String connectString, int sessionTimeout, String lockBasePath, String lockName, boolean sequentialLockName) throws IOException {
        this.lockBasePath = lockBasePath;
        this.lockName = lockName;
        this.sequentialLockName = sequentialLockName;
        this.zk = new ZooKeeper(connectString, sessionTimeout, (Watcher)this);
        int count = 0;
        while (!this.response) {
            if (count > 30) {
                throw new IOException("Unable to connect to Zookeeper");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            ++count;
        }
    }
}

