/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.util.r;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanDockerManager;
import fr.ens.biologie.genomique.eoulsan.util.r.ProcessRExecutor;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class DockerRExecutor
extends ProcessRExecutor {
    public static final String REXECUTOR_NAME = "docker";
    private final String dockerImage;

    @Override
    public String getName() {
        return REXECUTOR_NAME;
    }

    @Override
    protected void putFile(DataFile inputFile, String outputFilename) throws IOException {
        DataFile outputFile = new DataFile(this.getOutputDirectory(), outputFilename);
        if (DockerRExecutor.isSameLocalPath(inputFile, outputFile)) {
            return;
        }
        if (!inputFile.isLocalFile()) {
            super.putFile(inputFile, outputFilename);
            return;
        }
        File inFile = inputFile.toFile();
        if (!DockerRExecutor.isInSubDir(this.getOutputDirectory(), inFile) && !DockerRExecutor.isInSubDir(this.getTemporaryDirectory(), inFile)) {
            if (outputFile.exists()) {
                throw new IOException("The output file already exists: " + outputFile);
            }
            DataFiles.copy(inputFile, outputFile);
        } else {
            super.putFile(inputFile, outputFilename);
        }
    }

    private static boolean isInSubDir(File a, File b) {
        File aAbs = DockerRExecutor.getCanonicalOrAbsoluteFile(a);
        File bAbs = DockerRExecutor.getCanonicalOrAbsoluteFile(b);
        URI aURI = aAbs.toURI();
        URI bURI = bAbs.toURI();
        return !bURI.equals(aURI.relativize(bURI));
    }

    private static File getCanonicalOrAbsoluteFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    @Override
    protected SimpleProcess createSimpleProcess() throws IOException {
        return EoulsanDockerManager.getInstance().createImageInstance(this.dockerImage);
    }

    public DockerRExecutor(File outputDirectory, File temporaryDirectory, String dockerImage) throws IOException {
        super(outputDirectory, temporaryDirectory);
        if (dockerImage == null) {
            throw new NullPointerException("dockerImage argument cannot be null");
        }
        this.dockerImage = dockerImage;
    }
}

