/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util.process;

import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.process.DockerClient;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import fr.ens.biologie.genomique.kenetre.util.process.DockerJavaDockerImageInstance;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DockerJavaDockerClient
implements DockerClient {
    private com.github.dockerjava.api.DockerClient client;
    private final GenericLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(URI dockerConnectionURI) throws IOException {
        Objects.requireNonNull(dockerConnectionURI);
        DockerJavaDockerClient dockerJavaDockerClient = this;
        synchronized (dockerJavaDockerClient) {
            if (this.client != null) {
                return;
            }
            DockerJavaDockerClient dockerJavaDockerClient2 = this;
            synchronized (dockerJavaDockerClient2) {
                DefaultDockerClientConfig standard = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
                ZerodepDockerHttpClient httpClient = new ZerodepDockerHttpClient.Builder().dockerHost(dockerConnectionURI).build();
                this.client = DockerClientImpl.getInstance((DockerClientConfig)standard, (DockerHttpClient)httpClient);
                if (this.client == null) {
                    throw new IOException("Unable to connect to Docker deamon: " + dockerConnectionURI);
                }
            }
        }
    }

    @Override
    public DockerImageInstance createConnection(String dockerImage) throws IOException {
        return this.createConnection(dockerImage, false);
    }

    @Override
    public DockerImageInstance createConnection(String dockerImage, boolean mountFileIndirections) throws IOException {
        if (this.client == null) {
            throw new IllegalStateException("Docker client not initialized");
        }
        return new DockerJavaDockerImageInstance(this.client, dockerImage, mountFileIndirections, this.logger);
    }

    @Override
    public Set<String> listImageTags() throws IOException {
        HashSet<String> result = new HashSet<String>();
        List list = (List)this.client.listImagesCmd().exec();
        for (Image image : list) {
            if (image.getRepoTags() == null || image.getRepoTags().length <= 0) continue;
            result.add(image.getRepoTags()[0]);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public DockerJavaDockerClient() {
        this(null);
    }

    public DockerJavaDockerClient(GenericLogger logger) {
        this.logger = logger == null ? new DummyLogger() : logger;
    }
}

