/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util.process;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import fr.ens.biologie.genomique.kenetre.util.process.AbstractSimpleProcess;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import fr.ens.biologie.genomique.kenetre.util.process.DockerUtils;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DockerJavaDockerImageInstance
extends AbstractSimpleProcess
implements DockerImageInstance {
    private final DockerClient dockerClient;
    private final String dockerImage;
    private final int userUid;
    private final int userGid;
    private final boolean convertNFSFilesToMountRoots;
    private final GenericLogger logger;

    public SimpleProcess.AdvancedProcess start(List<String> commandLine, File executionDirectory, Map<String, String> environmentVariables, File temporaryDirectory, File stdoutFile, File stderrFile, boolean redirectErrorStream, File ... filesUsed) throws IOException {
        Objects.requireNonNull(commandLine, "commandLine argument cannot be null");
        Objects.requireNonNull(stdoutFile, "stdoutFile argument cannot be null");
        Objects.requireNonNull(stderrFile, "stderrFile argument cannot be null");
        this.logger.debug(this.getClass().getSimpleName() + ": commandLine=" + commandLine + ", executionDirectory=" + executionDirectory + ", environmentVariables=" + environmentVariables + ", temporaryDirectory=" + temporaryDirectory + ", stdoutFile=" + stdoutFile + ", stderrFile=" + stderrFile + ", redirectErrorStream=" + redirectErrorStream + ", filesUsed=" + Arrays.toString(filesUsed));
        if (executionDirectory != null) {
            Preconditions.checkArgument((boolean)executionDirectory.isDirectory(), (Object)("execution directory does not exists or is not a directory: " + executionDirectory.getAbsolutePath()));
        }
        ArrayList<String> env = new ArrayList<String>();
        if (environmentVariables != null) {
            for (Map.Entry<String, String> e : environmentVariables.entrySet()) {
                env.add(e.getKey() + '=' + e.getValue());
            }
        }
        this.pullImageIfNotExists();
        this.logger.debug("Configure container, command to execute: " + commandLine);
        CreateContainerCmd cmd = this.dockerClient.createContainerCmd(this.dockerImage).withCmd(commandLine);
        if (executionDirectory != null) {
            cmd.withWorkingDir(executionDirectory.getAbsolutePath());
        }
        if (this.userUid >= 0 && this.userGid >= 0) {
            cmd.withUser(this.userUid + ":" + this.userGid);
        }
        ArrayList<File> toBind = new ArrayList<File>();
        if (filesUsed != null) {
            toBind.addAll(Utils.filterNull(Arrays.asList(filesUsed)));
        }
        if (temporaryDirectory != null && temporaryDirectory.isDirectory()) {
            toBind.add(temporaryDirectory);
            env.add("TMPDIR=" + temporaryDirectory.getAbsolutePath());
        }
        cmd.getHostConfig().setBinds(DockerJavaDockerImageInstance.createBinds(executionDirectory, toBind, this.convertNFSFilesToMountRoots, this.logger).toArray(new Bind[0]));
        cmd.withEnv(env);
        CreateContainerResponse container = cmd.exec();
        String containerId = container.getId();
        this.logger.debug("Start of the Docker container: " + containerId);
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.redirect(containerId, stdoutFile, stderrFile, redirectErrorStream);
        InspectContainerResponse.ContainerState state = this.dockerClient.inspectContainerCmd(containerId).exec().getState();
        if ("running".equals(state.getStatus()) && state.getPidLong() == 0L) {
            throw new IOException("Error while executing container, container pid is 0");
        }
        return () -> {
            this.logger.debug("Wait the end of the Docker container: " + containerId);
            ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(containerId).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            InspectContainerResponse.ContainerState exitState = this.dockerClient.inspectContainerCmd(containerId).exec().getState();
            long exitValue = exitState.getExitCodeLong();
            this.logger.debug("Exit value: " + exitValue);
            this.logger.debug("Remove Docker container: " + containerId);
            this.dockerClient.removeContainerCmd(containerId).exec();
            return (int)exitValue;
        };
    }

    private void redirect(String containerId, File stdout, File stderr, boolean redirectErrorStream) throws FileNotFoundException {
        LogContainerCmd logContainerCmd = this.dockerClient.logContainerCmd(containerId);
        logContainerCmd.withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true));
        ResultCallback.Adapter callback = redirectErrorStream ? new LogWriteRedirect(stdout, stderr) : new LogWriteAll(stdout, stderr);
        try {
            ((ResultCallback.Adapter)logContainerCmd.exec((ResultCallback)callback)).awaitCompletion();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
        }
    }

    @Override
    public void pullImageIfNotExists() throws IOException {
        String imageName = this.dockerImage;
        String tag = "";
        int pos = this.dockerImage.lastIndexOf(58);
        if (pos != 1) {
            imageName = this.dockerImage.substring(0, pos);
            tag = this.dockerImage.substring(pos + 1);
        }
        try {
            ((PullImageResultCallback)this.dockerClient.pullImageCmd(imageName).withTag(tag).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void pullImageIfNotExists(DockerImageInstance.ProgressHandler progress) throws IOException {
        this.pullImageIfNotExists();
    }

    private static List<Bind> createBinds(File executionDirectory, List<File> files, boolean convertNFSFilesToMountRoots, GenericLogger logger) throws IOException {
        ArrayList<Bind> binds = new ArrayList<Bind>();
        HashSet<File> mounted = new HashSet<File>();
        if (executionDirectory != null) {
            File f = convertNFSFilesToMountRoots ? DockerUtils.convertNFSFileToMountPoint(executionDirectory, logger) : executionDirectory;
            binds.add(Bind.parse((String)(f.getAbsolutePath() + ':' + f.getAbsolutePath())));
            mounted.add(f.getAbsoluteFile());
        }
        if (files != null) {
            for (File f : DockerUtils.fileIndirections(DockerUtils.convertNFSFileToMountPoint(files, convertNFSFilesToMountRoots, logger))) {
                if (mounted.contains(f.getAbsoluteFile())) continue;
                binds.add(Bind.parse((String)(f.getAbsolutePath() + ':' + f.getAbsolutePath())));
                mounted.add(f.getAbsoluteFile());
            }
        }
        return binds;
    }

    DockerJavaDockerImageInstance(DockerClient dockerClient, String dockerImage, boolean mountFileIndirections, GenericLogger logger) {
        Objects.requireNonNull(dockerClient, "dockerClient argument cannot be null");
        Objects.requireNonNull(dockerImage, "dockerImage argument cannot be null");
        Objects.requireNonNull(logger, "logger argument cannot be null");
        logger.debug(this.getClass().getSimpleName() + " docker image used: " + dockerImage);
        this.dockerClient = dockerClient;
        this.dockerImage = dockerImage;
        this.userUid = SystemUtils.uid();
        this.userGid = SystemUtils.gid();
        this.convertNFSFilesToMountRoots = mountFileIndirections;
        this.logger = logger;
    }

    class LogWriteRedirect
    extends ResultCallback.Adapter<Frame> {
        final OutputStream stdoutChannel;
        final OutputStream stderrChannel;

        public void onComplete() {
            super.onComplete();
            try {
                this.stdoutChannel.close();
                this.stderrChannel.close();
            }
            catch (IOException e) {
                DockerJavaDockerImageInstance.this.logger.error(e.getMessage());
            }
        }

        public void onError(Throwable arg0) {
            super.onComplete();
            try {
                this.stdoutChannel.close();
                this.stderrChannel.close();
            }
            catch (IOException e) {
                DockerJavaDockerImageInstance.this.logger.error(e.getMessage());
            }
        }

        public void onNext(Frame item) {
            try {
                switch (item.getStreamType()) {
                    case STDOUT: {
                        this.stdoutChannel.write(item.getPayload());
                        break;
                    }
                    case STDERR: {
                        this.stderrChannel.write(item.getPayload());
                        break;
                    }
                }
            }
            catch (IOException e) {
                DockerJavaDockerImageInstance.this.logger.error(e.getMessage());
            }
        }

        LogWriteRedirect(File stdoutFile, File stderrFile) throws FileNotFoundException {
            this.stdoutChannel = new FileOutputStream(stdoutFile);
            this.stderrChannel = new FileOutputStream(stderrFile);
        }
    }

    class LogWriteAll
    extends ResultCallback.Adapter<Frame> {
        final OutputStream stdoutChannel;
        final OutputStream stderrChannel;

        public void onComplete() {
            super.onComplete();
            try {
                this.stdoutChannel.close();
                this.stderrChannel.close();
            }
            catch (IOException e) {
                DockerJavaDockerImageInstance.this.logger.error(e.getMessage());
            }
        }

        public void onError(Throwable arg0) {
            super.onComplete();
            try {
                this.stdoutChannel.close();
                this.stderrChannel.close();
            }
            catch (IOException e) {
                DockerJavaDockerImageInstance.this.logger.error(e.getMessage());
            }
        }

        public void onNext(Frame item) {
            try {
                switch (item.getStreamType()) {
                    case STDOUT: {
                        this.stdoutChannel.write(item.getPayload());
                        break;
                    }
                    case STDERR: {
                        this.stderrChannel.write(item.getPayload());
                        break;
                    }
                }
            }
            catch (IOException e) {
                DockerJavaDockerImageInstance.this.logger.error(e.getMessage());
            }
        }

        LogWriteAll(File stdoutFile, File stderrFile) throws FileNotFoundException {
            this.stdoutChannel = new FileOutputStream(stdoutFile);
            this.stderrChannel = new FileOutputStream(stderrFile);
        }
    }
}

