/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util.process;

import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.process.DockerClient;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import fr.ens.biologie.genomique.kenetre.util.process.DockerJavaDockerClient;
import fr.ens.biologie.genomique.kenetre.util.process.FallBackDockerClient;
import fr.ens.biologie.genomique.kenetre.util.process.Singularity3DockerClient;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Set;

public class DockerManager {
    private static DockerManager singleton;
    private final DockerClient client;

    public DockerImageInstance createImageInstance(String dockerImage) throws IOException {
        return this.client.createConnection(dockerImage);
    }

    public Set<String> listImageTags() throws IOException {
        return this.client.listImageTags();
    }

    public static void closeConnections() throws IOException {
        if (singleton != null) {
            DockerManager.singleton.client.close();
        }
    }

    public static DockerManager getInstance() throws IOException {
        return DockerManager.getInstance(ClientType.DEFAULT, URI.create("unix:///var/run/docker.sock"));
    }

    public static DockerManager getInstance(ClientType clientType, URI dockerConnection) throws IOException {
        return DockerManager.getInstance(clientType, dockerConnection, null);
    }

    public static synchronized DockerManager getInstance(ClientType clientType, URI dockerConnection, GenericLogger logger) throws IOException {
        if (singleton == null) {
            singleton = new DockerManager(clientType, dockerConnection, logger);
        }
        return singleton;
    }

    private DockerManager(ClientType clientType, URI dockerConnection, GenericLogger logger) throws IOException {
        Objects.requireNonNull(clientType);
        Objects.requireNonNull(dockerConnection);
        switch (clientType) {
            case FALLBACK: {
                this.client = new FallBackDockerClient(logger);
                break;
            }
            case SINGULARITY: {
                this.client = new Singularity3DockerClient(logger);
                break;
            }
            case DEFAULT: 
            case DOCKER_JAVA: {
                this.client = new DockerJavaDockerClient(logger);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported Docker client implementation: " + (Object)((Object)clientType));
            }
        }
        this.client.initialize(dockerConnection);
    }

    public static enum ClientType {
        DEFAULT,
        DOCKER_JAVA,
        SINGULARITY,
        FALLBACK;


        public static ClientType parseClientName(String name) {
            if (name == null) {
                return DEFAULT;
            }
            switch (name.toLowerCase().trim()) {
                case "docker-java": 
                case "docker_java": 
                case "dockerjava": {
                    return DOCKER_JAVA;
                }
                case "singularity": {
                    return SINGULARITY;
                }
                case "fallback": {
                    return FALLBACK;
                }
            }
            return DEFAULT;
        }
    }
}

