/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util.process;

import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DockerUtils {
    static Set<File> convertNFSFileToMountPoint(Collection<File> files, boolean convertNFSFilesToMountRoots, GenericLogger logger) throws IOException {
        Objects.requireNonNull(files);
        Objects.requireNonNull(logger);
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        for (File file : files) {
            if (file == null || !file.exists()) continue;
            result.add(convertNFSFilesToMountRoots ? DockerUtils.convertNFSFileToMountPoint(file, logger) : file);
        }
        return result;
    }

    static File convertNFSFileToMountPoint(File file, GenericLogger logger) throws IOException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(logger);
        FileStore fileStore = Files.getFileStore(file.toPath());
        logger.info("file: " + file + ", fileSystem type: " + fileStore.type());
        if ("nfs".equals(fileStore.type()) || "nfs4".equals(fileStore.type())) {
            String info = fileStore.toString();
            String mountPoint = info.substring(0, info.length() - fileStore.name().length() - 3);
            return new File(mountPoint);
        }
        return file;
    }

    static Set<File> fileIndirections(Collection<File> files) throws IOException {
        Objects.requireNonNull(files);
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        for (File f : files) {
            if (f == null) continue;
            result.addAll(DockerUtils.fileIndirections(f));
        }
        return result;
    }

    private static Set<File> fileIndirections(File file) throws IOException {
        Objects.requireNonNull(file);
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        DockerUtils.fileIndirections(file, result);
        return result;
    }

    private static void fileIndirections(File file, Set<File> result) throws IOException {
        if (file == null) {
            return;
        }
        if (result.contains(file)) {
            return;
        }
        File previousFile = new File("/");
        for (File f : DockerUtils.parentDirectories(file)) {
            Path path = f.toPath();
            if (Files.isSymbolicLink(path)) {
                Path link = Files.readSymbolicLink(path);
                if (!link.isAbsolute()) {
                    link = new File(previousFile, link.toString()).toPath();
                }
                DockerUtils.fileIndirections(link.toFile().getAbsoluteFile(), result);
                result.add(f);
            }
            previousFile = f;
        }
        result.add(file);
    }

    private static List<File> parentDirectories(File file) {
        ArrayList<File> result = new ArrayList<File>();
        File f = file;
        do {
            result.add(0, f);
        } while ((f = f.getParentFile()) != null);
        return result;
    }

    private DockerUtils() {
        throw new IllegalStateException();
    }
}

