/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util.process;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import fr.ens.biologie.genomique.kenetre.util.process.AbstractSimpleProcess;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import fr.ens.biologie.genomique.kenetre.util.process.DockerUtils;
import fr.ens.biologie.genomique.kenetre.util.process.ProcessUtils;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FallBackDockerImageInstance
extends AbstractSimpleProcess
implements DockerImageInstance {
    private final String dockerImage;
    private final int userUid;
    private final int userGid;
    private final boolean convertNFSFilesToMountRoots;
    private final GenericLogger logger;

    public SimpleProcess.AdvancedProcess start(List<String> commandLine, File executionDirectory, Map<String, String> environmentVariables, File temporaryDirectory, File stdoutFile, File stderrFile, boolean redirectErrorStream, File ... filesUsed) throws IOException {
        Objects.requireNonNull(commandLine, "commandLine argument cannot be null");
        Objects.requireNonNull(stdoutFile, "stdoutFile argument cannot be null");
        Objects.requireNonNull(stderrFile, "stderrFile argument cannot be null");
        this.logger.debug(this.getClass().getSimpleName() + ": commandLine=" + commandLine + ", executionDirectory=" + executionDirectory + ", environmentVariables=" + environmentVariables + ", temporaryDirectory=" + temporaryDirectory + ", stdoutFile=" + stdoutFile + ", stderrFile=" + stderrFile + ", redirectErrorStream=" + redirectErrorStream + ", filesUsed=" + Arrays.toString(filesUsed));
        if (executionDirectory != null) {
            Preconditions.checkArgument((boolean)executionDirectory.isDirectory(), (Object)("execution directory does not exists or is not a directory: " + executionDirectory.getAbsolutePath()));
        }
        this.pullImageIfNotExists();
        ArrayList<String> command = new ArrayList<String>();
        command.add("docker");
        command.add("run");
        ArrayList<File> directoriesToBind = new ArrayList<File>();
        if (filesUsed != null) {
            directoriesToBind.addAll(Utils.filterNull(Arrays.asList(filesUsed)));
        }
        if (executionDirectory != null) {
            directoriesToBind.add(executionDirectory);
            command.add("--workdir");
            command.add(executionDirectory.getAbsolutePath());
        }
        if (environmentVariables != null) {
            for (Map.Entry<String, String> e : environmentVariables.entrySet()) {
                command.add("--env");
                command.add(e.getKey() + '=' + e.getValue());
            }
        }
        if (temporaryDirectory != null && temporaryDirectory.isDirectory()) {
            directoriesToBind.add(temporaryDirectory);
        }
        FallBackDockerImageInstance.toBind(command, directoriesToBind, this.convertNFSFilesToMountRoots, this.logger);
        if (this.userUid >= 0 && this.userGid >= 0) {
            command.add("--user");
            command.add(this.userUid + ":" + this.userGid);
        }
        command.add("--rm");
        command.add(this.dockerImage);
        command.addAll(commandLine);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectOutput(stdoutFile);
        pb.redirectErrorStream(redirectErrorStream);
        if (!redirectErrorStream) {
            pb.redirectError(stderrFile);
        }
        Process process = pb.start();
        return () -> {
            try {
                return process.waitFor();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        };
    }

    private static void toBind(List<String> command, List<File> files, boolean convertNFSFilesToMountRoots, GenericLogger logger) throws IOException {
        for (File file : DockerUtils.fileIndirections(DockerUtils.convertNFSFileToMountPoint(files, convertNFSFilesToMountRoots, logger))) {
            command.add("--volume");
            command.add(file.getAbsolutePath() + ':' + file.getAbsolutePath());
        }
    }

    @Override
    public void pullImageIfNotExists() throws IOException {
        int exitCode;
        String images = ProcessUtils.execToString((String)"docker images | tr -s ' ' | cut -f 1,2 -d ' ' | tr ' ' :");
        for (String image : images.split("\n")) {
            if (!this.dockerImage.equals(image)) continue;
            return;
        }
        this.logger.debug("Pull Docker image: " + this.dockerImage);
        Process p = new ProcessBuilder("docker", "pull", this.dockerImage).start();
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Error while pulling Docker image: " + this.dockerImage);
        }
        if (exitCode != 0) {
            throw new IOException("Error while pulling Docker image: " + this.dockerImage);
        }
    }

    @Override
    public void pullImageIfNotExists(DockerImageInstance.ProgressHandler progress) throws IOException {
        if (progress != null) {
            progress.update(0.0);
        }
        this.pullImageIfNotExists();
        if (progress != null) {
            progress.update(1.0);
        }
    }

    FallBackDockerImageInstance(String dockerImage, boolean mountFileIndirections, GenericLogger logger) {
        Objects.requireNonNull(dockerImage, "dockerImage argument cannot be null");
        Objects.requireNonNull(logger, "logger argument cannot be null");
        logger.debug(this.getClass().getSimpleName() + " docker image used: " + dockerImage);
        this.dockerImage = dockerImage;
        this.userUid = SystemUtils.uid();
        this.userGid = SystemUtils.gid();
        this.convertNFSFilesToMountRoots = mountFileIndirections;
        this.logger = logger;
    }
}

