/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.io;

import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.UnSynchronizedBufferedWriter;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final boolean USE_CHANNEL = false;

    public static InputStream createInputStream(String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("The filename is null.");
        }
        return FileUtils.createInputStream(new File(filename));
    }

    public static InputStream createInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("The file is null.");
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("The file is a directory: " + file);
        }
        return new FileInputStream(file);
    }

    public static OutputStream createOutputStream(String filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("The filename is null.");
        }
        return FileUtils.createOutputStream(new File(filename));
    }

    public static OutputStream createOutputStream(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file is null.");
        }
        if (file.isFile() && !file.delete()) {
            throw new IOException("Can not remove existing file: " + file.getAbsolutePath());
        }
        return new FileOutputStream(file);
    }

    public static BufferedReader createBufferedReader(String filename) throws FileNotFoundException {
        return FileUtils.createBufferedReader(filename, null);
    }

    public static BufferedReader createBufferedReader(String filename, Charset charset) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("The filename is null");
        }
        return FileUtils.createBufferedReader(new File(filename), charset);
    }

    public static BufferedReader createBufferedReader(File file) throws FileNotFoundException {
        return FileUtils.createBufferedReader(file, null);
    }

    public static BufferedReader createBufferedReader(File file, Charset charset) throws FileNotFoundException {
        InputStream is = FileUtils.createInputStream(file);
        if (charset != null) {
            return new BufferedReader(new InputStreamReader(is, charset));
        }
        return new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
    }

    public static BufferedReader createBufferedReader(InputStream is) {
        return FileUtils.createBufferedReader(is, null);
    }

    public static BufferedReader createBufferedReader(InputStream is, Charset charset) {
        if (is == null) {
            throw new NullPointerException("The input stream is null");
        }
        if (charset != null) {
            return new BufferedReader(new InputStreamReader(is, charset));
        }
        return new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
    }

    public static UnSynchronizedBufferedWriter createFastBufferedWriter(String filename, Charset charset) throws IOException {
        if (filename == null) {
            throw new NullPointerException("The filename is null");
        }
        return FileUtils.createFastBufferedWriter(new File(filename), charset);
    }

    public static UnSynchronizedBufferedWriter createFastBufferedWriter(String filename) throws IOException {
        return FileUtils.createFastBufferedWriter(filename, null);
    }

    public static UnSynchronizedBufferedWriter createFastBufferedWriter(File file) throws IOException {
        return FileUtils.createFastBufferedWriter(file, null);
    }

    public static UnSynchronizedBufferedWriter createFastBufferedWriter(File file, Charset charset) throws IOException {
        OutputStream os = FileUtils.createOutputStream(file);
        return new UnSynchronizedBufferedWriter(new OutputStreamWriter(os, charset != null ? charset : Charset.defaultCharset()));
    }

    public static UnSynchronizedBufferedWriter createFastBufferedWriter(OutputStream os) throws FileNotFoundException {
        return FileUtils.createFastBufferedWriter(os, null);
    }

    public static UnSynchronizedBufferedWriter createFastBufferedWriter(OutputStream os, Charset charset) throws FileNotFoundException {
        if (os == null) {
            throw new NullPointerException("The output stream is null");
        }
        return new UnSynchronizedBufferedWriter(new OutputStreamWriter(os, charset != null ? charset : Charset.defaultCharset()));
    }

    public static UnSynchronizedBufferedWriter createFastBufferedGZipWriter(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Can not remove existing file: " + file.getAbsolutePath());
        }
        FileOutputStream outFile = new FileOutputStream(file);
        FileChannel outChannel = outFile.getChannel();
        OutputStream gzos = CompressionType.createGZipOutputStream(Channels.newOutputStream(outChannel));
        return new UnSynchronizedBufferedWriter(new OutputStreamWriter(gzos, Charset.defaultCharset()));
    }

    public static BufferedWriter createBufferedWriter(String filename) throws IOException {
        return FileUtils.createBufferedWriter(filename, null);
    }

    public static BufferedWriter createBufferedWriter(String filename, Charset charset) throws IOException {
        if (filename == null) {
            throw new NullPointerException("The filename is null");
        }
        return FileUtils.createBufferedWriter(new File(filename), charset);
    }

    public static BufferedWriter createBufferedWriter(File file) throws IOException {
        return FileUtils.createBufferedWriter(file, null);
    }

    public static BufferedWriter createBufferedWriter(File file, Charset charset) throws IOException {
        OutputStream os = FileUtils.createOutputStream(file);
        return new BufferedWriter(new OutputStreamWriter(os, charset != null ? charset : Charset.defaultCharset()));
    }

    public static BufferedWriter createBufferedWriter(OutputStream os) throws FileNotFoundException {
        return FileUtils.createBufferedWriter(os, null);
    }

    public static BufferedWriter createBufferedWriter(OutputStream os, Charset charset) throws FileNotFoundException {
        if (os == null) {
            throw new NullPointerException("The output stream is null");
        }
        return new BufferedWriter(new OutputStreamWriter(os, charset != null ? charset : Charset.defaultCharset()));
    }

    public static BufferedWriter createBufferedGZipWriter(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Can not remove existing file: " + file.getAbsolutePath());
        }
        FileOutputStream outFile = new FileOutputStream(file);
        FileChannel outChannel = outFile.getChannel();
        OutputStream gzos = CompressionType.createGZipOutputStream(Channels.newOutputStream(outChannel));
        return new BufferedWriter(new OutputStreamWriter(gzos, Charset.defaultCharset()));
    }

    public static ObjectOutputStream createObjectOutputWriter(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Can not remove existing file: " + file.getAbsolutePath());
        }
        FileOutputStream outFile = new FileOutputStream(file);
        FileChannel outChannel = outFile.getChannel();
        return new ObjectOutputStream(Channels.newOutputStream(outChannel));
    }

    public static ObjectInputStream createObjectInputReader(File file) throws IOException {
        if (file == null) {
            return null;
        }
        FileInputStream inFile = new FileInputStream(file);
        FileChannel inChannel = inFile.getChannel();
        return new ObjectInputStream(Channels.newInputStream(inChannel));
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        input.close();
        output.close();
        return count;
    }

    public static long append(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        input.close();
        return count;
    }

    public static boolean copyFile(File srcFile, File destFile) throws IOException {
        return FileUtils.copyFile(srcFile, destFile, false);
    }

    public static boolean copyFile(File srcFile, File destFile, boolean overwrite) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Input file is null");
        }
        if (destFile == null) {
            throw new NullPointerException("output file is null");
        }
        if (!srcFile.exists()) {
            throw new IOException("Source file doesn't exists: " + srcFile);
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Can't copy/move a directory: " + srcFile);
        }
        File myDestFile = destFile.isDirectory() ? new File(destFile, srcFile.getName()) : destFile;
        if (destFile.exists()) {
            if (!overwrite) {
                return false;
            }
            if (!myDestFile.delete()) {
                throw new IOException("Can not remove existing file: " + myDestFile.getAbsolutePath());
            }
        }
        try (FileChannel inChannel = new FileInputStream(srcFile).getChannel();
             FileChannel outChannel = new FileOutputStream(myDestFile).getChannel();){
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        return true;
    }

    public static boolean moveFile(File srcFile, File destFile) throws IOException {
        return FileUtils.moveFile(srcFile, destFile, true);
    }

    public static boolean moveFile(File srcFile, File destFile, boolean overwrite) throws IOException {
        return FileUtils.copyFile(srcFile, destFile, overwrite) && srcFile.delete();
    }

    public static void createZip(File directory, File zipFile) throws IOException {
        FileUtils.createZip(directory, zipFile, false);
    }

    public static void createZip(File directory, File zipFile, boolean store) throws IOException {
        FileUtils.createZip(directory, null, zipFile, store);
    }

    public static void createZip(File directory, Collection<File> rootFilesToStore, File zipFile, boolean store) throws IOException {
        if (directory == null) {
            throw new IOException("Input directory is null");
        }
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Invalid directory (" + directory + ")");
        }
        if (zipFile == null) {
            throw new IOException("Output file is null");
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        FileUtils.zipFolder(directory, "", rootFilesToStore, out, store);
        out.close();
    }

    public static void zipFolder(File directory, String path, ZipOutputStream out, boolean store) throws IOException {
        FileUtils.zipFolder(directory, path, null, out, store);
    }

    public static void zipFolder(File directory, String path, Collection<File> rootFilesToStore, ZipOutputStream out, boolean store) throws IOException {
        File[] directoriesToAdd;
        File[] filesToAdd;
        if (directory == null) {
            throw new IOException("Input directory is null");
        }
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Invalid directory (" + directory + ")");
        }
        if (path == null) {
            throw new NullPointerException("path argument cannot be null");
        }
        if (out == null) {
            throw new NullPointerException("out argument cannot be null");
        }
        if (!"".equals(path)) {
            out.putNextEntry(new ZipEntry(path));
        }
        if ((filesToAdd = directory.listFiles(file -> {
            if (rootFilesToStore == null) {
                return file.isFile();
            }
            return rootFilesToStore.contains(file) && file.isFile();
        })) != null) {
            byte[] data = new byte[4096];
            BufferedInputStream origin = null;
            File[] fileArray = filesToAdd;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                int count;
                FileInputStream fi;
                File f = fileArray[i];
                ZipEntry ze = new ZipEntry(path + f.getName());
                if (store) {
                    fi = new FileInputStream(f);
                    CheckedInputStream originCheck = new CheckedInputStream(new BufferedInputStream(fi, 4096), new CRC32());
                    while (originCheck.read(data, 0, 4096) != -1) {
                    }
                    fi.close();
                    ze.setMethod(0);
                    ze.setCrc(originCheck.getChecksum().getValue());
                } else {
                    ze.setMethod(8);
                }
                ze.setSize(f.length());
                out.putNextEntry(ze);
                fi = new FileInputStream(f);
                origin = new BufferedInputStream(fi, 4096);
                while ((count = origin.read(data, 0, 4096)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
        }
        if ((directoriesToAdd = directory.listFiles(file -> {
            if (rootFilesToStore == null) {
                return file.isDirectory();
            }
            return rootFilesToStore.contains(file) && file.isDirectory();
        })) != null) {
            for (File dir : directoriesToAdd) {
                FileUtils.zipFolder(dir, path + dir.getName() + File.separator, null, out, store);
            }
        }
    }

    public static void unzip(InputStream is, File outputDirectory) throws IOException {
        ZipEntry entry;
        if (is == null) {
            throw new IOException("The inputStream is null");
        }
        if (outputDirectory == null) {
            throw new IOException("The output directory is null");
        }
        if (!outputDirectory.exists() || !outputDirectory.isDirectory()) {
            throw new IOException("The output directory is invalid (" + outputDirectory + ")");
        }
        BufferedOutputStream dest = null;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            File newFile = new File(outputDirectory + File.separator + entry.getName());
            if (entry.isDirectory()) {
                if (newFile.exists() || newFile.mkdirs()) continue;
                throw new IOException("Cannot create directory: " + newFile);
            }
            File parentFile = newFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException("Cannot create directory: " + parentFile);
            }
            byte[] data = new byte[4096];
            FileOutputStream fos = new FileOutputStream(newFile);
            dest = new BufferedOutputStream(fos, 4096);
            while ((count = zis.read(data, 0, 4096)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
    }

    public static void unzip(File zipFile, File outputDirectory) throws IOException {
        if (zipFile == null) {
            throw new IOException("The zip file is null");
        }
        if (!zipFile.exists() || !zipFile.isFile()) {
            throw new IOException("Invalid zip file (" + zipFile.getName() + ")");
        }
        FileUtils.unzip(new FileInputStream(zipFile), outputDirectory);
    }

    public static File[] listFilesByExtension(File directory, String extension) {
        if (directory == null || extension == null) {
            return null;
        }
        return directory.listFiles((arg0, arg1) -> arg1.endsWith(extension));
    }

    public static boolean removeFiles(File[] filesToRemove, boolean recursive) {
        if (filesToRemove == null) {
            return false;
        }
        for (File f : filesToRemove) {
            if (f.isDirectory()) {
                if (!recursive) continue;
                if (!FileUtils.removeFiles(FileUtils.listFilesByExtension(f, ""), true)) {
                    return false;
                }
                if (f.delete()) continue;
                return false;
            }
            if (f.delete()) continue;
            return false;
        }
        return true;
    }

    public static String getPrefix(List<File> files) {
        if (files == null) {
            return null;
        }
        File[] param = new File[files.size()];
        files.toArray(param);
        return FileUtils.getPrefix(param);
    }

    public static String getPrefix(File[] files) {
        if (files == null) {
            return null;
        }
        String prefix = null;
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            String filename = file.getName();
            if (prefix == null) {
                prefix = filename;
                continue;
            }
            if (filename.startsWith(prefix)) continue;
            int max = Math.min(prefix.length(), filename.length());
            for (int j = 0; j < max; ++j) {
                if (prefix.charAt(j) != filename.charAt(j)) continue;
                sb.append(prefix.charAt(j));
            }
            prefix = sb.toString();
            sb.setLength(0);
        }
        return prefix;
    }

    public static boolean removeDirectory(File directory) {
        File[] files;
        if (directory == null) {
            return false;
        }
        for (File file : files = directory.listFiles()) {
            if (file.delete()) continue;
            return false;
        }
        return directory.delete();
    }

    public static void concat(List<File> files, File outputFile) throws IOException {
        if (files == null) {
            throw new NullPointerException("Files to concat is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("Output file is null");
        }
        UnSynchronizedBufferedWriter writer = FileUtils.createFastBufferedWriter(outputFile);
        for (File f : files) {
            String line;
            BufferedReader reader = FileUtils.createBufferedReader(f);
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\n");
            }
        }
        writer.close();
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFile(null, prefix, suffix);
    }

    public static File createFileInTempDir(String filename) {
        return new File(System.getProperty("java.io.tmpdir"), filename);
    }

    public static File createTempFile(File directory, String prefix, String suffix) throws IOException {
        String filename;
        File tempFile;
        File myDir = directory == null ? new File(System.getProperty("java.io.tmpdir")) : directory;
        String myPrefix = prefix == null ? "" : prefix;
        String mySuffix = suffix == null ? "" : suffix;
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while ((tempFile = new File(myDir, filename = myPrefix + UUID.randomUUID().toString() + mySuffix)).exists());
        if (!tempFile.createNewFile()) {
            throw new IOException("Failed to create temp file named " + tempFile.getAbsolutePath());
        }
        return tempFile;
    }

    public static File createTempDir() throws IOException {
        return FileUtils.createTempDir(null, null);
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileUtils.createTempDir(null, prefix);
    }

    public static File createTempDir(File parentDirectory) throws IOException {
        return FileUtils.createTempDir(parentDirectory, null);
    }

    public static File createTempDir(File parentDirectory, String prefix) throws IOException {
        String dirName;
        File newTempDir;
        File myTempParentDir = parentDirectory == null ? new File(System.getProperty("java.io.tmpdir")) : parentDirectory;
        String myPrefix = prefix == null ? "" : prefix;
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while ((newTempDir = new File(myTempParentDir, dirName = myPrefix + UUID.randomUUID().toString())).exists());
        if (newTempDir.mkdirs()) {
            return newTempDir;
        }
        throw new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath());
    }

    public static boolean recursiveDelete(File fileOrDir) {
        if (fileOrDir == null) {
            return false;
        }
        if (fileOrDir.isDirectory()) {
            for (File innerFile : fileOrDir.listFiles()) {
                if (FileUtils.recursiveDelete(innerFile)) continue;
                return false;
            }
        }
        return fileOrDir.delete();
    }

    public static void checkExistingFile(File file, String msgFileType) throws IOException {
        if (msgFileType == null) {
            throw new NullPointerException("Message file type for check isn't defined");
        }
        if (file == null) {
            throw new NullPointerException("The " + msgFileType + " is not defined. Please check and define " + msgFileType + " path and/or files.");
        }
        if (!file.exists()) {
            throw new IOException("The " + msgFileType + " does not exists: " + file.getAbsolutePath());
        }
    }

    public static void checkExistingDirectoryFile(File directory, String msgFileType) throws IOException {
        FileUtils.checkExistingFile(directory, msgFileType);
        if (!directory.isDirectory()) {
            throw new IOException("The " + msgFileType + " is not a directory: " + directory.getAbsolutePath());
        }
    }

    public static void checkExistingStandardFile(File file, String msgFileType) throws IOException {
        FileUtils.checkExistingFile(file, msgFileType);
        if (!file.isFile()) {
            throw new IOException("The " + msgFileType + " is  not a standard file: " + file.getAbsolutePath());
        }
    }

    public static void checkExistingStandardFileOrDirectory(File file, String msgFileType) throws IOException {
        FileUtils.checkExistingDirectoryFile(file, msgFileType);
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException("The " + msgFileType + " is  not a standard file or a directory: " + file.getAbsolutePath());
        }
    }

    public static boolean compareFile(InputStream a, InputStream b) throws IOException {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        boolean end = false;
        boolean result = true;
        while (!end) {
            int cb;
            int ca = a.read();
            if (ca != (cb = b.read())) {
                result = false;
                end = true;
            }
            if (ca != -1) continue;
            end = true;
        }
        a.close();
        b.close();
        return result;
    }

    public static boolean compareFile(String filenameA, String filenameB) throws IOException {
        return FileUtils.compareFile(new File(filenameA), new File(filenameB));
    }

    /*
     * Exception decompiling
     */
    public static boolean compareFile(File fileA, File fileB) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String computeMD5Sum(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file argument is null");
        }
        return FileUtils.computeMD5Sum(new FileInputStream(file));
    }

    public static String computeMD5Sum(InputStream inputStream) throws IOException {
        MessageDigest md5Digest;
        Objects.requireNonNull(inputStream, "inputStream argument cannot be null");
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("No MD5 digest algorithm found: " + e.getMessage());
        }
        try (InputStream in = inputStream;){
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = in.read(buffer))) {
                md5Digest.update(buffer, 0, n);
            }
        }
        return StringUtils.md5DigestToString(md5Digest);
    }

    public static File relativizePath(File path, File base) {
        int i;
        if (path == null) {
            throw new NullPointerException("The path is null");
        }
        if (base == null) {
            return path;
        }
        File absPath = path.getAbsoluteFile();
        File absBase = base.getAbsoluteFile();
        ArrayList<String> pathNodes = new ArrayList<String>();
        ArrayList<String> baseNodes = new ArrayList<String>();
        File parent = absPath;
        do {
            pathNodes.add(parent.getName());
        } while ((parent = parent.getParentFile()) != null);
        parent = absBase;
        do {
            baseNodes.add(parent.getName());
        } while ((parent = parent.getParentFile()) != null);
        Collections.reverse(pathNodes);
        Collections.reverse(baseNodes);
        int minSize = Math.min(pathNodes.size(), baseNodes.size());
        for (i = 0; i < minSize && ((String)pathNodes.get(i)).equals(baseNodes.get(i)); ++i) {
        }
        ArrayList<String> resultNodes = new ArrayList<String>();
        if (i < baseNodes.size()) {
            for (int j = 0; j < baseNodes.size() - i; ++j) {
                resultNodes.add("..");
            }
        }
        resultNodes.addAll(pathNodes.subList(i, pathNodes.size()));
        return FileUtils.createFile(resultNodes);
    }

    private static File createFile(List<String> pathNodes) {
        File result = null;
        for (String f : pathNodes) {
            if (result == null) {
                result = new File(f);
                continue;
            }
            result = new File(result, f);
        }
        return result;
    }

    public static void createNamedPipe(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file argument cannot be null");
        }
        if (file.exists()) {
            throw new IOException("Named pipe to create already exists: " + file);
        }
        Process process = new ProcessBuilder("mkfifo", file.getAbsolutePath()).start();
        try {
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new IOException("Unable to create named pipe: " + file);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to create named pipe: " + file, e);
        }
    }

    public static boolean checkIfExecutableIsInPATH(String executableName) {
        String[] paths;
        if (executableName == null) {
            throw new NullPointerException("executableName argument cannot be null");
        }
        String pathEnv = System.getenv("PATH");
        if (pathEnv == null) {
            return false;
        }
        FilenameFilter filter = (dir, name) -> executableName.equals(name);
        for (String path : paths = pathEnv.split(":")) {
            File[] files;
            File f;
            if ((path = path.trim()).isEmpty() || !(f = new File(path)).exists() || !(f.isFile() ? executableName.equals(f.getName()) : (files = f.listFiles(filter)) != null && files.length > 0)) continue;
            return true;
        }
        return false;
    }

    public static final class SuffixFilenameFilter
    implements FilenameFilter {
        private final String suffix;
        private final boolean allowCompressedFile;

        @Override
        public boolean accept(File file, String name) {
            if (name == null) {
                return false;
            }
            String myName = this.allowCompressedFile ? StringUtils.removeCompressedExtensionFromFilename(name) : name;
            return myName.endsWith(this.suffix);
        }

        public SuffixFilenameFilter(String suffix) {
            this(suffix, false);
        }

        public SuffixFilenameFilter(String suffix, boolean allowCompressedFile) {
            if (suffix == null) {
                throw new NullPointerException("The suffix is null");
            }
            this.suffix = suffix;
            this.allowCompressedFile = allowCompressedFile;
        }
    }

    public static final class PrefixFilenameFilter
    implements FilenameFilter {
        private final String prefix;
        private final boolean allowCompressedFile;

        @Override
        public boolean accept(File file, String name) {
            if (name == null) {
                return false;
            }
            String myName = this.allowCompressedFile ? StringUtils.removeCompressedExtensionFromFilename(name) : name;
            return myName.startsWith(this.prefix);
        }

        public PrefixFilenameFilter(String prefix) {
            this(prefix, false);
        }

        public PrefixFilenameFilter(String prefix, boolean allowCompressedFile) {
            if (prefix == null) {
                throw new NullPointerException("The prefix is null");
            }
            this.prefix = prefix;
            this.allowCompressedFile = allowCompressedFile;
        }
    }
}

