/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.io;

import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ReporterLogReader {
    private static final Charset CHARSET = Charset.defaultCharset();
    private final BufferedReader reader;

    public Reporter read() throws IOException {
        LocalReporter result = new LocalReporter();
        String line = null;
        String counterGroup = null;
        while ((line = this.reader.readLine()) != null) {
            String tLine = line.trim();
            if ("".equals(tLine) || tLine.startsWith("Start time:") || tLine.startsWith("End time:") || tLine.startsWith("Duration:")) continue;
            if (line.startsWith("\t")) {
                int separatorIndex;
                if (counterGroup == null || (separatorIndex = tLine.indexOf(61)) == -1) continue;
                String counter = tLine.substring(0, separatorIndex);
                try {
                    int value = Integer.parseInt(tLine.substring(separatorIndex + 1));
                    result.setCounter(counterGroup, counter, value);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            counterGroup = line;
        }
        this.reader.close();
        return result;
    }

    public ReporterLogReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(is, CHARSET));
    }

    public ReporterLogReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        this.reader = FileUtils.createBufferedReader(file);
    }
}

