/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BinariesInstaller {
    private static final int BUFFER_SIZE = 32768;
    public static final Set<String> AVAILABLE_BINARY_ARCH = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("linux\tamd64", "linux\tx86_64")));
    public static final Map<String, String> AVAILABLE_BINARY_ARCH_ALIAS = Collections.unmodifiableMap(Collections.singletonMap("linux\tx86_64", "linux\tamd64"));
    private GenericLogger logger;
    private String appName;
    private String appLowerCaseName;
    private String appVersion;

    private void install(String inputPath, String file, String outputPath) throws IOException {
        String resourcePath;
        InputStream is;
        if (new File(outputPath, file).isFile()) {
            this.logger.debug(file + " is already installed.");
            return;
        }
        File outputDir = new File(outputPath);
        if (!outputDir.isDirectory()) {
            if (!outputDir.mkdirs()) {
                throw new IOException("Can't create directory for binaries installation: " + outputDir.getAbsolutePath());
            }
            outputDir.setWritable(true, false);
        }
        if ((is = BinariesInstaller.class.getResourceAsStream(resourcePath = inputPath.toLowerCase() + "/" + file)) == null) {
            throw new FileNotFoundException("Unable to find the correct resource (" + resourcePath + ")");
        }
        File outputFile = new File(outputDir, file);
        OutputStream fos = FileUtils.createOutputStream(outputFile);
        byte[] buf = new byte[32768];
        int i = 0;
        while ((i = is.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        is.close();
        fos.close();
        outputFile.setExecutable(true, false);
        outputFile.setReadable(true, false);
    }

    public String install(String softwarePackage, String packageVersion, String binaryFilename, String tempDir) throws IOException {
        File tempDirFile = new File(tempDir == null ? System.getProperty("java.io.tmpdir") : tempDir.trim());
        if (!tempDirFile.exists()) {
            throw new IOException("Temporary directory does not exits: " + tempDirFile);
        }
        if (!tempDirFile.isDirectory()) {
            throw new IOException("Temporary directory is not a directory: " + tempDirFile);
        }
        String outputPath = tempDirFile.getAbsolutePath() + "/" + this.appLowerCaseName + "/" + this.appVersion + "/" + softwarePackage + "/" + packageVersion;
        if (new File(outputPath, binaryFilename).isFile()) {
            this.logger.info(binaryFilename + " is already installed.");
            return outputPath + "/" + binaryFilename;
        }
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        this.logger.debug("Try to install \"" + binaryFilename + "\" of " + softwarePackage + " package for " + os + " (" + arch + ")");
        String inputPath = this.getInputPath(softwarePackage, packageVersion);
        this.install(inputPath, binaryFilename, outputPath);
        this.logger.debug("Successful installation of " + binaryFilename + " in " + outputPath);
        return outputPath + "/" + binaryFilename;
    }

    public boolean check(String softwarePackage, String packageVersion, String binaryFilename) {
        try {
            String inputPath = this.getInputPath(softwarePackage, packageVersion);
            String resourcePath = inputPath.toLowerCase() + "/" + binaryFilename;
            InputStream is = BinariesInstaller.class.getResourceAsStream(resourcePath);
            if (is == null) {
                return false;
            }
            is.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private String getInputPath(String softwarePackage, String packageVersion) throws IOException {
        if (!SystemUtils.isUnix()) {
            throw new IOException("Can only install binaries on *nix systems.");
        }
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String osArchKey = os + "\t" + arch;
        if (!AVAILABLE_BINARY_ARCH.contains(osArchKey)) {
            throw new FileNotFoundException("There is no executable for your platform (" + os + ") included in " + this.appName);
        }
        if (AVAILABLE_BINARY_ARCH_ALIAS.containsKey(osArchKey)) {
            osArchKey = AVAILABLE_BINARY_ARCH_ALIAS.get(osArchKey);
        }
        return '/' + osArchKey.replace(" ", "").replace('\t', '/') + (softwarePackage == null ? "" : '/' + softwarePackage.trim()) + (packageVersion == null ? "" : '/' + packageVersion);
    }

    public BinariesInstaller(String applicationName, String version) {
        this(applicationName, version, null);
    }

    public BinariesInstaller(String applicationName, String applicationVersion, GenericLogger logger) {
        Objects.requireNonNull(applicationName);
        Objects.requireNonNull(applicationVersion);
        this.appName = applicationName.trim();
        this.appLowerCaseName = this.appName.toLowerCase();
        this.appVersion = applicationVersion != null ? applicationVersion.trim() : "unknown-version";
        this.logger = logger != null ? logger : new DummyLogger();
    }
}

