/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LocalReporter
implements Reporter {
    private final Map<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();

    @Override
    public void incrCounter(String counterGroup, String counter, long amount) {
        Map<Object, Object> group;
        if (counterGroup == null || counter == null || amount <= 0L) {
            return;
        }
        if (!this.map.containsKey(counterGroup)) {
            group = new HashMap();
            this.map.put(counterGroup, group);
        } else {
            group = this.map.get(counterGroup);
        }
        long value = 0L;
        if (group.containsKey(counter)) {
            value = (Long)group.get(counter);
        }
        group.put(counter, value += amount);
    }

    public void setCounter(String counterGroup, String counter, long value) {
        Map<Object, Object> group;
        if (counterGroup == null || counter == null || value <= 0L) {
            return;
        }
        if (!this.map.containsKey(counterGroup)) {
            group = new HashMap();
            this.map.put(counterGroup, group);
        } else {
            group = this.map.get(counterGroup);
        }
        group.put(counter, value);
    }

    @Override
    public long getCounterValue(String counterGroup, String counter) {
        if (counterGroup == null || counter == null) {
            return -1L;
        }
        Map<String, Long> group = this.map.get(counterGroup);
        if (group == null) {
            return -1L;
        }
        Long value = group.get(counter);
        if (value == null) {
            return -1L;
        }
        return value;
    }

    @Override
    public Set<String> getCounterGroups() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Set<String> getCounterNames(String group) {
        if (group == null || !this.map.containsKey(group)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.map.get(group).keySet());
    }

    public void clear() {
        this.map.clear();
    }

    public String countersValuesToString(String counterGroup, String header) {
        Map<String, Long> group;
        StringBuilder sb = new StringBuilder();
        if (header != null) {
            sb.append(header);
            sb.append('\n');
        }
        if ((group = this.map.get(counterGroup)) != null) {
            ArrayList counterNames = Lists.newArrayList(group.keySet());
            Collections.sort(counterNames);
            for (String counterName : counterNames) {
                sb.append('\t');
                sb.append(counterName);
                sb.append('=');
                sb.append(group.get(counterName));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList groups = Lists.newArrayList(this.getCounterGroups());
        Collections.sort(groups);
        for (String counterGroup : groups) {
            sb.append(counterGroup);
            sb.append('\n');
            sb.append(this.countersValuesToString(counterGroup, null));
        }
        return sb.toString();
    }
}

