/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PseudoMapReduce {
    private static final Charset CHARSET = Charset.forName(System.getProperty("file.encoding"));
    private File tmpDir;
    private final List<File> listMapOutputFile = new ArrayList<File>();
    private File sortOutputFile;
    private final LocalReporter reporter = new LocalReporter();
    private final GenericLogger logger;

    public abstract void map(String var1, List<String> var2, Reporter var3) throws IOException;

    public abstract void reduce(String var1, Iterator<String> var2, List<String> var3, Reporter var4) throws IOException;

    public Reporter getReporter() {
        return this.reporter;
    }

    public GenericLogger getLogger() {
        return this.logger;
    }

    public void doMap(File inputFile) throws IOException {
        if (inputFile == null) {
            throw new NullPointerException("The input file is null.");
        }
        this.doMap(FileUtils.createInputStream(inputFile));
    }

    protected File getMapOutputTempFile() throws IOException {
        File outputFile = File.createTempFile("map-", ".txt", this.tmpDir);
        this.listMapOutputFile.add(outputFile);
        return outputFile;
    }

    public void doMap(InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("The input stream is null.");
        }
        this.reporter.clear();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, CHARSET));
             FileWriter bw = new FileWriter(this.getMapOutputTempFile());){
            String line;
            ArrayList<String> results = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                this.map(line, results, this.reporter);
                for (String r : results) {
                    sb.setLength(0);
                    sb.append(r);
                    sb.append('\n');
                    bw.write(sb.toString());
                }
                results.clear();
            }
        }
    }

    public void setMapReduceTemporaryDirectory(File directory) {
        this.tmpDir = directory;
    }

    public File getMapReduceTemporaryDirectory() {
        return this.tmpDir;
    }

    private boolean sort() throws IOException {
        boolean result;
        this.sortOutputFile = File.createTempFile("sort-", ".txt", this.tmpDir);
        if (this.listMapOutputFile.isEmpty()) {
            this.sortOutputFile.createNewFile();
            return true;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("sort");
        if (this.tmpDir != null) {
            command.add("-T");
            command.add(this.tmpDir.getAbsolutePath());
        }
        command.add("-o");
        command.add(this.sortOutputFile.getAbsolutePath());
        for (File mapOutputFile : this.listMapOutputFile) {
            command.add(mapOutputFile.getAbsolutePath());
        }
        try {
            result = new ProcessBuilder(command).start().waitFor() == 0;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        for (File mapOutputFile : this.listMapOutputFile) {
            if (mapOutputFile.delete()) continue;
            this.logger.warn("Can not delete map output file: " + mapOutputFile.getAbsolutePath());
        }
        return result;
    }

    public void doReduce(File outputFile) throws IOException {
        if (outputFile == null) {
            throw new NullPointerException("The output file is null.");
        }
        this.doReduce(FileUtils.createOutputStream(outputFile));
    }

    public void doReduce(OutputStream os) throws IOException {
        if (os == null) {
            throw new NullPointerException("The output stream is null.");
        }
        if (!this.sort()) {
            throw new IOException("Unable to sort/shuffle data.");
        }
        BufferedReader br = FileUtils.createBufferedReader(this.sortOutputFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, CHARSET));
        String line = null;
        String currentKey = null;
        RepeatedEntriesList<String> values = new RepeatedEntriesList<String>();
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            int indexFirstTab = line.indexOf(9);
            if (line.isEmpty() || indexFirstTab == -1) continue;
            String key = line.substring(0, indexFirstTab);
            String value = line.substring(indexFirstTab + 1);
            if (currentKey == null) {
                currentKey = key;
            } else if (!key.equals(currentKey)) {
                this.reduce(currentKey, values.iterator(), results, this.reporter);
                for (String result : results) {
                    sb.setLength(0);
                    sb.append(result);
                    sb.append('\n');
                    bw.write(sb.toString());
                }
                results.clear();
                values.clear();
                currentKey = key;
            }
            values.add(value);
        }
        if (currentKey != null) {
            this.reduce(currentKey, values.iterator(), results, this.reporter);
        }
        for (String result : results) {
            bw.write(result);
        }
        br.close();
        bw.close();
        if (!this.sortOutputFile.delete()) {
            this.logger.warn("Can not delete sort output file: " + this.sortOutputFile.getAbsolutePath());
        }
    }

    protected PseudoMapReduce() {
        this(null);
    }

    protected PseudoMapReduce(GenericLogger logger) {
        this.logger = logger != null ? logger : new DummyLogger();
    }

    private static final class RepeatedEntriesList<E>
    extends AbstractList<E> {
        private int count;
        private final Map<E, Integer> map = new LinkedHashMap<E, Integer>();

        private RepeatedEntriesList() {
        }

        @Override
        public E get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public boolean add(E e) {
            if (this.map.containsKey(e)) {
                int count = this.map.get(e);
                this.map.put(e, count + 1);
                return true;
            }
            this.map.put(e, 1);
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<Map.Entry<E, Integer>> it;
                private E currentValue;
                private int currentCount;
                {
                    this.it = map.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext() || this.currentCount > 0;
                }

                @Override
                public E next() {
                    if (this.currentCount == 0) {
                        if (!this.it.hasNext()) {
                            return null;
                        }
                        Map.Entry e = this.it.next();
                        this.currentValue = e.getKey();
                        this.currentCount = e.getValue();
                    }
                    --this.currentCount;
                    return this.currentValue;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

