/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import fr.ens.biologie.genomique.kenetre.util.ServiceListLoader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;

public abstract class ServiceNameLoader<S> {
    public static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final ClassLoader loader;
    private final ListMultimap<String, String> classNames = ArrayListMultimap.create();
    private final ListMultimap<String, S> cache = ArrayListMultimap.create();
    private final Set<String> classesToNotLoad = new HashSet<String>();
    private boolean notYetLoaded = true;

    protected abstract boolean accept(Class<?> var1);

    protected abstract String getMethodName();

    protected boolean isCache() {
        return false;
    }

    protected boolean isServiceNameCaseSensible() {
        return false;
    }

    public void addClassToNotLoad(String className) {
        if (className == null) {
            throw new NullPointerException("className argument cannot be null");
        }
        this.classesToNotLoad.add(className.trim());
    }

    public void addClassesToNotLoad(Collection<String> classNames) {
        if (classNames == null) {
            throw new NullPointerException("classNames argument cannot be null");
        }
        for (String className : classNames) {
            if (className == null) continue;
            this.addClassToNotLoad(className);
        }
    }

    public void clearClassesToNotLoad() {
        this.classesToNotLoad.clear();
    }

    public void removeClassToNotLoad(String className) {
        if (className == null) {
            throw new NullPointerException("className argument cannot be null");
        }
        this.classesToNotLoad.remove(className.trim());
    }

    public void removeClassesToNotLoad(Collection<String> classNames) {
        if (classNames == null) {
            throw new NullPointerException("classNames argument cannot be null");
        }
        for (String className : classNames) {
            if (className == null) continue;
            this.removeClassToNotLoad(className);
        }
    }

    public Set<String> getClassesToNotLoad() {
        return Collections.unmodifiableSet(this.classesToNotLoad);
    }

    public void reload() {
        this.notYetLoaded = false;
        this.classNames.clear();
        this.cache.clear();
        if (this.getMethodName() == null) {
            throw new NullPointerException("getMethod() cannot return null");
        }
        try {
            for (ServiceListLoader.Entry e : ServiceListLoader.loadEntries(this.service.getName())) {
                if (this.classesToNotLoad.contains(e.getValue())) continue;
                this.processClassName(e.getUrl().toString(), e.getLineNumber(), e.getValue());
            }
        }
        catch (IOException e) {
            throw new ServiceConfigurationError(this.service.getName() + ": " + e.getMessage());
        }
    }

    private void processClassName(String url, int lineNumber, String className) {
        String serviceName;
        String name;
        Method m;
        S obj;
        Class<?> clazz;
        if (!ServiceNameLoader.checkClassName(className)) {
            throw new ServiceConfigurationError(this.service.getName() + ": " + url + ":" + lineNumber + ": Invalid Java class name");
        }
        try {
            clazz = Class.forName(className, false, this.loader);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceConfigurationError(this.service.getName() + ": " + url + ": Class not found: " + className);
        }
        if (!this.accept(clazz)) {
            return;
        }
        try {
            obj = this.service.cast(clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceConfigurationError(this.service.getName() + ": " + url + ": Class cannot be instanced: " + className);
        }
        try {
            m = obj.getClass().getMethod(this.getMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ServiceConfigurationError(this.service.getName() + ": " + url + ": Method " + this.getMethodName() + "() cannot be instanced in class: " + className);
        }
        try {
            name = (String)m.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ServiceConfigurationError(this.service.getName() + ": " + url + ": Method " + this.getMethodName() + "() cannot be invoked in class: " + className);
        }
        if (name == null) {
            throw new ServiceConfigurationError(this.service.getName() + ": " + url + ": Method " + this.getMethodName() + "() returns null");
        }
        String string = serviceName = this.isServiceNameCaseSensible() ? name : name.toLowerCase();
        if (!this.classNames.containsValue((Object)className)) {
            this.classNames.put((Object)serviceName, (Object)className);
        }
    }

    private static boolean checkClassName(String className) {
        if (className == null) {
            return false;
        }
        int len = className.length();
        if (len == 0) {
            return false;
        }
        int codePoint = className.codePointAt(0);
        if (!Character.isJavaIdentifierPart(codePoint)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            codePoint = className.codePointAt(i);
            if (Character.isJavaIdentifierPart(codePoint) || codePoint == 46) continue;
            return false;
        }
        return true;
    }

    public S newService(String serviceName) {
        List<S> newServices = this.newServices(serviceName);
        if (newServices.isEmpty()) {
            return null;
        }
        return newServices.get(0);
    }

    public List<S> newServices(String serviceName) {
        String serviceNameLower;
        if (serviceName == null) {
            return Collections.emptyList();
        }
        if (this.notYetLoaded) {
            this.reload();
        }
        String string = serviceNameLower = this.isServiceNameCaseSensible() ? serviceName.trim() : serviceName.toLowerCase().trim();
        if (this.cache.containsKey((Object)serviceNameLower)) {
            return this.cache.get((Object)serviceNameLower);
        }
        ArrayList<S> result = new ArrayList<S>();
        if (this.classNames.containsKey((Object)serviceNameLower)) {
            for (String className : this.classNames.get((Object)serviceNameLower)) {
                try {
                    Class<?> clazz = Class.forName(className, true, this.loader);
                    S newInstance = this.service.cast(clazz.newInstance());
                    if (this.isCache()) {
                        this.cache.put((Object)serviceNameLower, newInstance);
                    }
                    result.add(newInstance);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ServiceConfigurationError(this.service.getName() + ": " + serviceNameLower + " cannot be instanced");
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceConfigurationError(this.service.getName() + ": Class for " + serviceNameLower + " cannot be found");
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public ListMultimap<String, String> getServiceClasses() {
        if (this.notYetLoaded) {
            this.reload();
        }
        return Multimaps.unmodifiableListMultimap(this.classNames);
    }

    public boolean isService(String serviceName) {
        if (serviceName == null) {
            return false;
        }
        if (this.notYetLoaded) {
            this.reload();
        }
        String serviceNameLower = serviceName.toLowerCase().trim();
        return this.classNames.containsKey((Object)serviceNameLower);
    }

    public ServiceNameLoader(Class<S> service) {
        this(service, null);
    }

    public ServiceNameLoader(Class<S> service, ClassLoader loader) {
        if (service == null) {
            throw new NullPointerException("The service is null");
        }
        this.service = service;
        this.loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
    }
}

