/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class StringUtils {
    public static String basename(String filename) {
        return StringUtils.basename(filename, true);
    }

    public static String basename(String filename, boolean withoutCompressedExtension) {
        if (filename == null) {
            return null;
        }
        String myFilename = withoutCompressedExtension ? StringUtils.removeCompressedExtensionFromFilename(filename) : filename;
        File f = new File(myFilename);
        String shortName = f.getName();
        int pos = shortName.indexOf(46);
        if (pos == -1) {
            return myFilename;
        }
        return myFilename.substring(0, myFilename.length() - (shortName.length() - pos));
    }

    public static String extension(String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        String shortName = f.getName();
        int pos = shortName.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return filename.substring(filename.length() - (shortName.length() - pos));
    }

    public static String extensionWithoutCompressionExtension(String filename) {
        return StringUtils.extension(StringUtils.filenameWithoutCompressionExtension(filename));
    }

    public static String filenameWithoutExtension(String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        String shortName = f.getName();
        int pos = shortName.lastIndexOf(46);
        if (pos == -1) {
            return filename;
        }
        return filename.substring(0, filename.length() - shortName.length()) + shortName.subSequence(0, pos);
    }

    public static String compressionExtension(String filename) {
        if (filename == null) {
            return null;
        }
        String ext = StringUtils.extension(filename);
        if (".gz".equals(ext)) {
            return ext;
        }
        if (".bz2".equals(ext)) {
            return ext;
        }
        if (".zip".equals(ext)) {
            return ext;
        }
        if (".deflate".equals(ext)) {
            return ext;
        }
        if (".lzo".equals(ext)) {
            return ext;
        }
        return "";
    }

    public static String filenameWithoutCompressionExtension(String filename) {
        if (filename == null) {
            return null;
        }
        if (filename.endsWith(".gz")) {
            return filename.substring(0, filename.length() - 3);
        }
        if (filename.endsWith(".bz2")) {
            return filename.substring(0, filename.length() - 4);
        }
        if (filename.endsWith(".deflate")) {
            return filename.substring(0, filename.length() - 8);
        }
        if (filename.endsWith(".lzo")) {
            return filename.substring(0, filename.length() - 4);
        }
        return filename;
    }

    public static String removeNonAlphaAtEndOfString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        char c = s.charAt(len - 1);
        if (!Character.isLetter(c)) {
            return s.substring(0, len - 1);
        }
        return s;
    }

    public static String toTimeHumanReadable(long time) {
        long hour = time / 3600000L;
        long hourRest = time % 3600000L;
        long min = hourRest / 60000L;
        long minRest = hourRest % 60000L;
        long sec = minRest / 1000L;
        long mili = minRest % 1000L;
        return String.format("%02d:%02d:%02d.%03d", hour, min, sec, mili);
    }

    public static String toCompactTime(long millisSinceEpoch) {
        Calendar cal = Calendar.getInstance(Locale.ENGLISH);
        cal.setTime(new Date(millisSinceEpoch));
        return String.format("%04d%02d%02d-%02d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static List<String> fastSplit(String s, List<String> list) {
        if (s == null) {
            return null;
        }
        List<String> result = list == null ? new ArrayList<String>() : list;
        result.clear();
        int lastPos = 0;
        int pos = -1;
        while ((pos = s.indexOf("\t", lastPos)) != -1) {
            result.add(s.substring(lastPos, pos));
            lastPos = pos + 1;
        }
        result.add(s.substring(lastPos));
        return result;
    }

    public static String[] fastSplit(String s, String[] array) {
        return StringUtils.fastSplit(s, array, false);
    }

    public static String[] fastSplit(String s, String[] array, boolean allowEmptyFields) {
        if (array == null || s == null) {
            return null;
        }
        int lastPos = 0;
        int len = array.length - 1;
        for (int i = 0; i < len; ++i) {
            int pos = s.indexOf("\t", lastPos);
            if (pos == -1) {
                if (allowEmptyFields) {
                    while (i <= len) {
                        array[i++] = "";
                    }
                    return array;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            array[i] = s.substring(lastPos, pos);
            lastPos = pos + 1;
        }
        array[len] = s.substring(lastPos);
        return array;
    }

    public static String subStringAfterFirstTab(String s) {
        if (s == null) {
            return null;
        }
        int indexFirstTab = s.indexOf(9);
        if (indexFirstTab == -1) {
            return s;
        }
        return s.substring(indexFirstTab + 1);
    }

    public static String subStringBeforeFirstTab(String s) {
        if (s == null) {
            return null;
        }
        int indexFirstTab = s.indexOf(9);
        if (indexFirstTab == -1) {
            return s;
        }
        return s.substring(0, indexFirstTab);
    }

    public static String currentDateTimeToEasySortedDateTime() {
        return StringUtils.toEasySortedDateTime(new Date(System.currentTimeMillis()));
    }

    public static String toEasySortedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(Locale.ENGLISH);
        return String.format("%04d%02d%02d%02d%02d%02d", cal.get(1), cal.get(2), cal.get(5), cal.get(10), cal.get(12), cal.get(13));
    }

    public static String removeCompressedExtensionFromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        if (filename.endsWith(".gz")) {
            return filename.substring(0, filename.length() - 3);
        }
        if (filename.endsWith(".bz2")) {
            return filename.substring(0, filename.length() - 4);
        }
        if (filename.endsWith(".zip")) {
            return filename.substring(0, filename.length() - 4);
        }
        return filename;
    }

    public static String protectGFF(String s) {
        if (s == null) {
            return null;
        }
        String rTmp = s.replace("\\", "\\\\").replace(";", "\\;").replace("=", "\\=").replace("%", "\\%").replace("&", "\\&").replace(",", "\\,");
        StringBuilder sb = new StringBuilder();
        int len = rTmp.length();
        for (int i = 0; i < len; ++i) {
            char c = rTmp.charAt(i);
            if (c <= ' ') {
                sb.append('%');
                sb.append(String.format("%02X", c));
                continue;
            }
            sb.append(c);
        }
        String r = sb.toString();
        sb.setLength(0);
        return r;
    }

    public static String deProtectGFF(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i + 2 >= len) break;
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                if (Character.isDigit(d1) && Character.isDigit(d2)) {
                    sb.append((char)Integer.parseInt("" + d1 + d2, 16));
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString().replace("\\,", ",").replace("\\&", "&").replace("\\%", "%").replace("\\=", "=").replace("\\;", ";").replace("\\\\", "\\");
    }

    public static String[] arrayWithoutFirstElement(String[] array) {
        return StringUtils.arrayWithoutFirstsElement(array, 1);
    }

    public static String[] arrayWithoutFirstsElement(String[] array, int elementsToRemove) {
        if (array == null) {
            return null;
        }
        if (elementsToRemove < 1) {
            return array;
        }
        if (elementsToRemove > array.length) {
            return new String[0];
        }
        int newLen = array.length - elementsToRemove;
        String[] result = new String[newLen];
        System.arraycopy(array, elementsToRemove, result, 0, newLen);
        return result;
    }

    public static String bashEscaping(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\\", "\\\\").replace(" ", "\\ ").replace("'", "\\'").replace("\"", "\\\"").replace("&", "\\&").replace("!", "\\!").replace("~", "\\~");
    }

    public static String getURIFilename(String s) {
        if (s == null) {
            return null;
        }
        try {
            URI uri = new URI(s);
            return new File(uri.getPath()).getName();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String sizeToHumanReadable(long bytes) {
        double ki = 1024.0;
        double mi = 1048576.0;
        double gi = 1.073741824E9;
        double ti = 1.099511627776E12;
        if ((double)bytes < 1024.0) {
            return String.format("%d B", bytes);
        }
        if ((double)bytes < 1048576.0) {
            return String.format("%.2f KiB", (double)bytes / 1024.0);
        }
        if ((double)bytes < 1.073741824E9) {
            return String.format("%.2f MiB", (double)bytes / 1048576.0);
        }
        if ((double)bytes < 1.099511627776E12) {
            return String.format("%.2f GiB", (double)bytes / 1.073741824E9);
        }
        return String.format("%.2f TiB", (double)bytes / 1.099511627776E12);
    }

    public static boolean startsWith(String s, String[] prefixes) {
        if (s == null || prefixes == null) {
            return false;
        }
        for (String p : prefixes) {
            if (!s.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public static String getCommonContentTypeFromExtension(String extension) {
        if (extension == null) {
            return null;
        }
        switch (extension.toLowerCase()) {
            case ".htm": 
            case ".html": {
                return "text/html";
            }
            case ".xml": {
                return "text/xml";
            }
            case ".txt": 
            case ".pl": 
            case ".pm": 
            case ".py": 
            case ".r": 
            case ".rb": 
            case ".java": {
                return "text/plain";
            }
            case ".jpeg": 
            case ".jpg": 
            case ".jpe": {
                return "image/jpeg";
            }
            case ".tif": 
            case ".tiff": {
                return "image/tiff";
            }
            case ".png": {
                return "image/png";
            }
            case ".pdf": {
                return "application/pdf";
            }
        }
        return "";
    }

    public static String replacePrefix(String s, String oldPrefix, String newPrefix) {
        if (s == null) {
            return null;
        }
        if (oldPrefix == null || newPrefix == null) {
            return s;
        }
        if (!s.startsWith(oldPrefix)) {
            return s;
        }
        int prefixLen = oldPrefix.length();
        return newPrefix + s.substring(prefixLen);
    }

    public static String serializeStringArray(Collection<String> strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (s == null) continue;
            sb.append(s.replace("\\", "\\\\").replace(",", "\\,"));
        }
        sb.append(']');
        return sb.toString();
    }

    public static List<String> deserializeStringArray(String serializedString) {
        if (serializedString == null) {
            return null;
        }
        String s = serializedString.trim();
        if (s.charAt(0) != '[' || s.charAt(s.length() - 1) != ']') {
            return Collections.singletonList(serializedString);
        }
        s = s.substring(1, s.length() - 1);
        ArrayList<String> result = new ArrayList<String>();
        int last = 0;
        boolean escapeNext = false;
        for (int i = 0; i < s.length(); ++i) {
            if (escapeNext) {
                escapeNext = false;
                continue;
            }
            if (s.charAt(i) == '\\') {
                escapeNext = true;
                continue;
            }
            if (s.charAt(i) != ',') continue;
            result.add(s.substring(last, i).replace("\\\\", "\\").replace("\\,", ","));
            last = i + 1;
        }
        result.add(s.substring(last).replace("\\\\", "\\").replace("\\,", ","));
        return result;
    }

    public static char toLetter(int i) {
        if (i < 0) {
            return '-';
        }
        if (i > 25) {
            return '-';
        }
        return (char)(i + 97);
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static String join(Collection<String> collection, String separator) {
        if (collection == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : collection) {
            if (!first && separator != null) {
                sb.append(separator);
            }
            if (first) {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0 && separator != null) {
                sb.append(separator);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0 && separator != null) {
                sb.append(separator);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static Iterable<String> splitStringIterator(final String s, final int length) {
        if (s == null || length < 1) {
            return null;
        }
        return new IterableString(){
            int pos = 0;
            final int len = s.length();

            @Override
            public boolean hasNext() {
                return this.pos < this.len;
            }

            @Override
            public String next() {
                int endPos = this.pos + length > this.len ? this.len : this.pos + length;
                String result = s.substring(this.pos, endPos);
                this.pos += length;
                return result;
            }

            @Override
            public void remove() {
            }

            @Override
            public Iterator<String> iterator() {
                return this;
            }
        };
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static List<String> splitShellCommandLine(String commandline) {
        if (commandline == null) {
            return null;
        }
        String s = commandline.trim();
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        boolean inArgument = false;
        char quote = ' ';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escape) {
                if (c == '\"') {
                    sb.append(c);
                }
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (!(c != '\"' && c != '\'' || inArgument)) {
                quote = c;
                inArgument = true;
                continue;
            }
            if (c == ' ' && !inArgument || c == quote && inArgument) {
                if (inArgument) {
                    result.add(sb.toString());
                } else {
                    String s2 = sb.toString().trim();
                    if (!s2.isEmpty()) {
                        result.add(s2);
                    }
                }
                sb.setLength(0);
                inArgument = false;
                continue;
            }
            sb.append(c);
        }
        if (inArgument) {
            result.add(sb.toString());
        } else {
            String s2 = sb.toString().trim();
            if (!s2.isEmpty()) {
                result.add(s2);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static String doubleQuotes(String s) {
        if (s == null) {
            return null;
        }
        return '\"' + s + '\"';
    }

    public static String unDoubleQuotes(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 2) {
            return s;
        }
        if (s.charAt(0) == '\"' && s.charAt(len - 1) == '\"') {
            return s.substring(1, len - 1);
        }
        return s;
    }

    public static String stackTraceToString(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String xmlEscape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String md5DigestToString(MessageDigest md5Digest) {
        Objects.requireNonNull(md5Digest, "md argument cannot be null");
        if (!"MD5".equals(md5Digest.getAlgorithm())) {
            throw new IllegalArgumentException("the md argument must be a MD5 MessageDigest but found: " + md5Digest.getAlgorithm());
        }
        return new BigInteger(1, md5Digest.digest()).toString(16);
    }

    private StringUtils() {
    }

    private static interface IterableString
    extends Iterable<String>,
    Iterator<String> {
    }
}

