/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Utils {
    public static <K, V> Map<V, Set<K>> reverseMap(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        HashMap result = new HashMap();
        for (Map.Entry<K, V> e : map.entrySet()) {
            Set<K> set;
            V value = e.getValue();
            if (!result.containsKey(value)) {
                set = new HashSet();
                result.put(value, set);
            } else {
                set = (Set)result.get(value);
            }
            set.add(e.getKey());
        }
        return result;
    }

    public static <E> Set<E> unmodifiableSet(E[] array) {
        if (array == null) {
            return null;
        }
        List<E> list = Arrays.asList(array);
        return Collections.unmodifiableSet(new HashSet<E>(list));
    }

    public static <E> List<E> listWithoutNull(List<E> list) {
        if (list == null) {
            return null;
        }
        ArrayList<E> result = new ArrayList<E>();
        for (E e : list) {
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    public static boolean equal(Object a, Object b) {
        return Objects.equals(a, b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static void checkNotNull(Object object, String msg) {
        if (object == null) {
            throw new NullPointerException(msg);
        }
    }

    public static void checkState(boolean expression, String msg) {
        if (!expression) {
            throw new IllegalStateException(msg);
        }
    }

    public static <E> List<E> newArrayList(Collection<? extends E> elements) {
        return new ArrayList<E>(elements);
    }

    public static <E> HashSet<E> newHashSet(Collection<? extends E> elements) {
        return new HashSet<E>(elements);
    }

    public static void nop() {
    }

    public static <T> Iterable<T> newIterable(final Enumeration<T> e) {
        if (e == null) {
            return null;
        }
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> newIterable(Iterator<T> it) {
        if (it == null) {
            return null;
        }
        return () -> it;
    }

    public static <E> E[] filterNull(E[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<E> list = new ArrayList<E>(array.length);
        for (E e : array) {
            if (e == null) continue;
            list.add(e);
        }
        return list.toArray(new Object[0]);
    }

    public static <E> List<E> filterNull(List<E> list) {
        if (list == null) {
            return null;
        }
        ArrayList<E> result = new ArrayList<E>(list.size());
        for (E e : list) {
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> Set<E> filterNull(Set<E> set) {
        if (set == null) {
            return null;
        }
        HashSet result = new HashSet(set.size());
        result.remove(null);
        return result;
    }

    public static <E> void removeAllNull(Collection<E> collection) {
        if (collection == null) {
            return;
        }
        ArrayList<E> toRemove = new ArrayList<E>();
        for (E e : collection) {
            if (e != null) continue;
            toRemove.add(e);
        }
        collection.removeAll(toRemove);
    }
}

