/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import java.util.List;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    private static final char SEPARATOR = '.';
    private int major;
    private int minor;
    private int revision;
    private String type = "";

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getType() {
        return this.type;
    }

    public void setMajor(int major) {
        this.major = major >= 0 ? major : 0;
    }

    public void setMinor(int minor) {
        this.minor = minor >= 0 ? minor : 0;
    }

    public void setRevision(int revision) {
        this.revision = revision >= 0 ? revision : 0;
    }

    public void setType(String type) {
        this.type = type == null ? "" : type.trim();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajor());
        sb.append('.');
        sb.append(this.getMinor());
        if (this.getRevision() > 0) {
            sb.append('.');
            sb.append(this.getRevision());
        }
        sb.append(this.getType());
        return sb.toString();
    }

    public void setVersion(int major, int minor, int revision) {
        this.setVersion(major, minor, revision, null);
    }

    public void setVersion(int major, int minor, int revision, String type) {
        this.setMajor(major);
        this.setMinor(minor);
        this.setRevision(revision);
        this.setType(type);
    }

    public void setVersion(String version) {
        if (version == null) {
            return;
        }
        String v = version.trim();
        int fieldCount = 0;
        StringBuilder sb = new StringBuilder();
        boolean inType = false;
        try {
            for (int i = 0; i < v.length(); ++i) {
                char c = v.charAt(i);
                if (inType || Character.isDigit(c)) {
                    sb.append(c);
                    continue;
                }
                if (sb.length() > 0) {
                    switch (fieldCount) {
                        case 0: {
                            this.setMajor(Integer.parseInt(sb.toString()));
                            break;
                        }
                        case 1: {
                            this.setMinor(Integer.parseInt(sb.toString()));
                            break;
                        }
                        case 2: {
                            this.setRevision(Integer.parseInt(sb.toString()));
                            inType = true;
                            break;
                        }
                    }
                    sb.setLength(0);
                }
                if (c == '.') {
                    ++fieldCount;
                    continue;
                }
                inType = true;
                sb.append(c);
            }
            if (sb.length() > 0) {
                if (inType) {
                    this.setType(sb.toString());
                } else {
                    switch (fieldCount) {
                        case 0: {
                            this.setMajor(Integer.parseInt(sb.toString()));
                            break;
                        }
                        case 1: {
                            this.setMinor(Integer.parseInt(sb.toString()));
                            break;
                        }
                        case 2: {
                            this.setRevision(Integer.parseInt(sb.toString()));
                            break;
                        }
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format in string: " + version);
        }
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        int compMajor = Integer.compare(this.getMajor(), version.getMajor());
        if (compMajor != 0) {
            return compMajor;
        }
        int compMinor = Integer.compare(this.getMinor(), version.getMinor());
        if (compMinor != 0) {
            return compMinor;
        }
        int compRevision = Integer.compare(this.getRevision(), version.getRevision());
        if (compRevision != 0) {
            return compRevision;
        }
        return this.getType().compareTo(version.getType());
    }

    public boolean lessThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean lessThanOrEqualTo(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean greaterThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean greaterThanOrEqualTo(Version version) {
        return this.compareTo(version) >= 0;
    }

    public static Version getMinimalVersion(List<Version> versions) {
        if (versions == null || versions.size() == 0) {
            return null;
        }
        Version min = versions.get(0);
        for (Version v : versions) {
            if (min.compareTo(v) <= 0) continue;
            min = v;
        }
        return min;
    }

    public static Version getMaximalVersion(List<Version> versions) {
        if (versions == null || versions.size() == 0) {
            return null;
        }
        Version max = versions.get(0);
        for (Version v : versions) {
            if (max.compareTo(v) >= 0) continue;
            max = v;
        }
        return max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        return v.major == this.major && v.minor == this.minor && v.revision == this.revision && this.type.equals(v.type);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.type);
    }

    public Version() {
        this(null);
    }

    public Version(int major, int minor, int revision, String type) {
        this.setVersion(major, minor, revision, type);
    }

    public Version(int major, int minor, int revision) {
        this.setVersion(major, minor, revision);
    }

    public Version(String version) {
        this.setVersion(version);
    }
}

