/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLUtils {
    public static List<String> getAttributeNames(Element e) {
        if (e == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        NamedNodeMap map = e.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attribute = map.item(i);
            result.add(attribute.getNodeName());
        }
        return result;
    }

    public static String getAttributeValue(Element e, String attributeName) {
        if (e == null || attributeName == null) {
            return null;
        }
        return e.getAttribute(attributeName);
    }

    public static List<Element> getElementsByTagName(Element parentElement, String elementName) {
        if (elementName == null || parentElement == null) {
            return null;
        }
        NodeList nStepsList = parentElement.getElementsByTagName(elementName);
        if (nStepsList == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nStepsList.getLength(); ++i) {
            Node node = nStepsList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static List<Element> getElementsByTagName(Document document, String elementName) {
        if (elementName == null || document == null) {
            return null;
        }
        NodeList nStepsList = document.getElementsByTagName(elementName);
        if (nStepsList == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nStepsList.getLength(); ++i) {
            Node node = nStepsList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static String getTagValue(Element parentElement, String elementName) {
        if (parentElement == null || elementName == null) {
            return null;
        }
        String result = null;
        for (Element e : XMLUtils.getElementsByTagName(parentElement, elementName)) {
            result = e.getTextContent();
        }
        return result;
    }

    public static List<String> getTagValues(Element parentElement, String elementName) {
        if (parentElement == null || elementName == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element e : XMLUtils.getElementsByTagName(parentElement, elementName)) {
            result.add(e.getTextContent());
        }
        return result;
    }

    public static void addTagValue(Document doc, Element parentElement, String elementName, String value) {
        if (doc == null || parentElement == null || elementName == null || value == null) {
            return;
        }
        Element child = doc.createElement(elementName);
        parentElement.appendChild(child);
        child.appendChild(doc.createTextNode(value));
    }

    public static boolean isElementExistsByTagName(Element element, String tagName) {
        if (element == null || tagName == null || tagName.isEmpty()) {
            return false;
        }
        NodeList res = element.getChildNodes();
        for (int i = 0; i < res.getLength(); ++i) {
            Element elem;
            Node node = res.item(i);
            if (node.getNodeType() != 1 || !(elem = (Element)node).getTagName().equals(tagName)) continue;
            return true;
        }
        return false;
    }
}

