/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.util.process;

import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.process.AbstractSimpleProcess;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SystemSimpleProcess
extends AbstractSimpleProcess {
    private final GenericLogger logger;

    @Override
    public SimpleProcess.AdvancedProcess start(List<String> commandLine, File executionDirectory, Map<String, String> environmentVariables, File temporaryDirectory, File stdoutFile, File stderrFile, boolean redirectErrorStream, File ... filesUsed) throws IOException {
        this.logger.debug(this.getClass().getName() + " : commandLine=" + commandLine + ", executionDirectory=" + executionDirectory + ", environmentVariables=" + environmentVariables + ", temporaryDirectory=" + temporaryDirectory + ", stdoutFile=" + stdoutFile + ", stderrFile=" + stderrFile + ", redirectErrorStream=" + redirectErrorStream + ", filesUsed=" + Arrays.toString(filesUsed));
        ProcessBuilder pb = new ProcessBuilder(commandLine);
        if (executionDirectory != null) {
            pb.directory(executionDirectory);
        }
        if (environmentVariables != null) {
            pb.environment().putAll(environmentVariables);
        }
        if (temporaryDirectory != null) {
            pb.environment().put("TMPDIR", temporaryDirectory.getAbsolutePath());
        }
        if (stdoutFile != null) {
            pb.redirectOutput(stdoutFile);
        }
        if (redirectErrorStream) {
            pb.redirectErrorStream(true);
        } else if (stderrFile != null) {
            pb.redirectError(stderrFile);
        }
        Process process = pb.start();
        return () -> {
            try {
                return process.waitFor();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        };
    }

    public SystemSimpleProcess() {
        this(null);
    }

    public SystemSimpleProcess(GenericLogger logger) {
        this.logger = logger == null ? new DummyLogger() : logger;
    }
}

