/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Analysis;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import uk.ac.babraham.FastQC.Analysis.AnalysisListener;
import uk.ac.babraham.FastQC.Analysis.AnalysisRunner;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Modules.AdapterContent;
import uk.ac.babraham.FastQC.Modules.BasicStats;
import uk.ac.babraham.FastQC.Modules.KmerContent;
import uk.ac.babraham.FastQC.Modules.NContent;
import uk.ac.babraham.FastQC.Modules.OverRepresentedSeqs;
import uk.ac.babraham.FastQC.Modules.PerBaseQualityScores;
import uk.ac.babraham.FastQC.Modules.PerBaseSequenceContent;
import uk.ac.babraham.FastQC.Modules.PerSequenceGCContent;
import uk.ac.babraham.FastQC.Modules.PerSequenceQualityScores;
import uk.ac.babraham.FastQC.Modules.PerTileQualityScores;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Modules.SequenceLengthDistribution;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.SequenceFactory;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Utilities.CasavaBasename;

public class OfflineRunner
implements AnalysisListener {
    private int filesRemaining;
    private boolean showUpdates = true;

    public OfflineRunner(String[] filenames) {
        File[][] fileGroups;
        this.showUpdates = !FastQCConfig.getInstance().quiet;
        Vector<File> files = new Vector<File>();
        if (filenames.length == 1 && filenames[0].equals("stdin")) {
            files.add(new File("stdin"));
        } else {
            int f = 0;
            while (f < filenames.length) {
                File file = new File(filenames[f]);
                if (!file.exists() || !file.canRead()) {
                    System.err.println("Skipping '" + filenames[f] + "' which didn't exist, or couldn't be read");
                } else {
                    files.add(file);
                }
                ++f;
            }
        }
        if (FastQCConfig.getInstance().casava) {
            fileGroups = CasavaBasename.getCasavaGroups(files.toArray(new File[0]));
        } else {
            fileGroups = new File[files.size()][1];
            int f = 0;
            while (f < files.size()) {
                fileGroups[f][0] = (File)files.elementAt(f);
                ++f;
            }
        }
        this.filesRemaining = fileGroups.length;
        int i = 0;
        while (i < fileGroups.length) {
            try {
                this.processFile(fileGroups[i]);
            }
            catch (Exception e) {
                System.err.println("Failed to process " + fileGroups[i][0]);
                e.printStackTrace();
                --this.filesRemaining;
            }
            ++i;
        }
        while (this.filesRemaining > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    public void processFile(File[] files) throws Exception {
        int f = 0;
        while (f < files.length) {
            if (!files[f].getName().equals("stdin") && !files[f].exists()) {
                throw new IOException(String.valueOf(files[f].getName()) + " doesn't exist");
            }
            ++f;
        }
        SequenceFile sequenceFile = SequenceFactory.getSequenceFile(files);
        AnalysisRunner runner = new AnalysisRunner(sequenceFile);
        runner.addAnalysisListener(this);
        OverRepresentedSeqs os = new OverRepresentedSeqs();
        QCModule[] module_list = new QCModule[]{new BasicStats(), new PerBaseQualityScores(), new PerTileQualityScores(), new PerSequenceQualityScores(), new PerBaseSequenceContent(), new PerSequenceGCContent(), new NContent(), new SequenceLengthDistribution(), os.duplicationLevelModule(), os, new AdapterContent(), new KmerContent()};
        runner.startAnalysis(module_list);
    }

    public void analysisComplete(SequenceFile file, QCModule[] results) {
        File reportFile;
        if (this.showUpdates) {
            System.out.println("Analysis complete for " + file.name());
        }
        if (FastQCConfig.getInstance().output_dir != null) {
            String fileName = String.valueOf(file.getFile().getName().replaceAll("\\.gz$", "").replaceAll("\\.bz2$", "").replaceAll("\\.txt$", "").replaceAll("\\.fastq$", "").replaceAll("\\.fastq$", "").replaceAll("\\.csfastq$", "").replaceAll("\\.sam$", "").replaceAll("\\.bam$", "")) + "_fastqc.html";
            reportFile = new File(FastQCConfig.getInstance().output_dir + "/" + fileName);
        } else {
            reportFile = new File(String.valueOf(file.getFile().getAbsolutePath().replaceAll("\\.gz$", "").replaceAll("\\.bz2$", "").replaceAll("\\.txt$", "").replaceAll("\\.fastq$", "").replaceAll("\\.fq$", "").replaceAll("\\.csfastq$", "").replaceAll("\\.sam$", "").replaceAll("\\.bam$", "")) + "_fastqc.html");
        }
        try {
            new HTMLReportArchive(file, results, reportFile);
        }
        catch (Exception e) {
            this.analysisExceptionReceived(file, e);
            return;
        }
        --this.filesRemaining;
    }

    public void analysisUpdated(SequenceFile file, int sequencesProcessed, int percentComplete) {
        if (percentComplete % 5 == 0) {
            if (percentComplete == 105 && this.showUpdates) {
                System.err.println("It seems our guess for the total number of records wasn't very good.  Sorry about that.");
            }
            if (percentComplete > 100) {
                if (this.showUpdates) {
                    System.err.println("Still going at " + percentComplete + "% complete for " + file.name());
                }
            } else if (this.showUpdates) {
                System.err.println("Approx " + percentComplete + "% complete for " + file.name());
            }
        }
    }

    public void analysisExceptionReceived(SequenceFile file, Exception e) {
        System.err.println("Failed to process file " + file.name());
        e.printStackTrace();
        --this.filesRemaining;
    }

    public void analysisStarted(SequenceFile file) {
        if (this.showUpdates) {
            System.err.println("Started analysis of " + file.name());
        }
    }
}

