/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import uk.ac.babraham.FastQC.Analysis.AnalysisRunner;
import uk.ac.babraham.FastQC.Analysis.OfflineRunner;
import uk.ac.babraham.FastQC.Dialogs.WelcomePanel;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.FastQCMenuBar;
import uk.ac.babraham.FastQC.FileFilters.BAMFileFilter;
import uk.ac.babraham.FastQC.FileFilters.CasavaFastQFileFilter;
import uk.ac.babraham.FastQC.FileFilters.FastQFileFilter;
import uk.ac.babraham.FastQC.FileFilters.MappedBAMFileFilter;
import uk.ac.babraham.FastQC.FileFilters.SequenceFileFilter;
import uk.ac.babraham.FastQC.Modules.AdapterContent;
import uk.ac.babraham.FastQC.Modules.BasicStats;
import uk.ac.babraham.FastQC.Modules.KmerContent;
import uk.ac.babraham.FastQC.Modules.NContent;
import uk.ac.babraham.FastQC.Modules.OverRepresentedSeqs;
import uk.ac.babraham.FastQC.Modules.PerBaseQualityScores;
import uk.ac.babraham.FastQC.Modules.PerBaseSequenceContent;
import uk.ac.babraham.FastQC.Modules.PerSequenceGCContent;
import uk.ac.babraham.FastQC.Modules.PerSequenceQualityScores;
import uk.ac.babraham.FastQC.Modules.PerTileQualityScores;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Modules.SequenceLengthDistribution;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Results.ResultsPanel;
import uk.ac.babraham.FastQC.Sequence.SequenceFactory;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;
import uk.ac.babraham.FastQC.Utilities.CasavaBasename;

public class FastQCApplication
extends JFrame {
    public static final String VERSION = "0.11.2";
    private JTabbedPane fileTabs;
    private WelcomePanel welcomePanel;
    private File lastUsedDir = null;

    public FastQCApplication() {
        this.setTitle("FastQC");
        this.setIconImage(new ImageIcon(ClassLoader.getSystemResource("uk/ac/babraham/FastQC/Resources/fastqc_icon.png")).getImage());
        this.setDefaultCloseOperation(3);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.welcomePanel = new WelcomePanel();
        this.fileTabs = new JTabbedPane(1);
        this.setContentPane(this.welcomePanel);
        this.setJMenuBar(new FastQCMenuBar(this));
    }

    public void close() {
        if (this.fileTabs.getSelectedIndex() >= 0) {
            this.fileTabs.remove(this.fileTabs.getSelectedIndex());
        }
        if (this.fileTabs.getTabCount() == 0) {
            this.setContentPane(this.welcomePanel);
            this.validate();
            this.repaint();
        }
    }

    public void closeAll() {
        this.fileTabs.removeAll();
        this.setContentPane(this.welcomePanel);
        this.validate();
        this.repaint();
    }

    public void openFile() {
        File[][] fileGroups;
        JFileChooser chooser = this.lastUsedDir == null ? new JFileChooser() : new JFileChooser(this.lastUsedDir);
        chooser.setMultiSelectionEnabled(true);
        SequenceFileFilter sff = new SequenceFileFilter();
        chooser.addChoosableFileFilter(sff);
        chooser.addChoosableFileFilter(new FastQFileFilter());
        chooser.addChoosableFileFilter(new CasavaFastQFileFilter());
        chooser.addChoosableFileFilter(new BAMFileFilter());
        chooser.addChoosableFileFilter(new MappedBAMFileFilter());
        chooser.setFileFilter(sff);
        int result = chooser.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        FileFilter chosenFilter = chooser.getFileFilter();
        if (chosenFilter instanceof FastQFileFilter) {
            System.setProperty("fastqc.sequence_format", "fastq");
        }
        if (chosenFilter instanceof CasavaFastQFileFilter) {
            System.setProperty("fastqc.sequence_format", "fastq");
            System.setProperty("fastqc.casava", "true");
        } else if (chosenFilter instanceof BAMFileFilter) {
            System.setProperty("fastqc.sequence_format", "bam");
        } else if (chosenFilter instanceof MappedBAMFileFilter) {
            System.setProperty("fastqc.sequence_format", "bam_mapped");
        }
        if (this.fileTabs.getTabCount() == 0) {
            this.setContentPane(this.fileTabs);
            this.validate();
            this.repaint();
        }
        File[] files = chooser.getSelectedFiles();
        if (FastQCConfig.getInstance().casava) {
            fileGroups = CasavaBasename.getCasavaGroups(files);
        } else {
            fileGroups = new File[files.length][1];
            int f = 0;
            while (f < files.length) {
                fileGroups[f][0] = files[f];
                ++f;
            }
        }
        int i = 0;
        while (i < fileGroups.length) {
            block15: {
                SequenceFile sequenceFile;
                File[] filesToProcess = fileGroups[i];
                this.lastUsedDir = filesToProcess[0].getParentFile();
                try {
                    sequenceFile = SequenceFactory.getSequenceFile(filesToProcess);
                }
                catch (SequenceFormatException e) {
                    JPanel errorPanel = new JPanel();
                    errorPanel.setLayout(new BorderLayout());
                    errorPanel.add((Component)new JLabel("File format error: " + e.getLocalizedMessage(), 0), "Center");
                    this.fileTabs.addTab(filesToProcess[0].getName(), errorPanel);
                    e.printStackTrace();
                    break block15;
                }
                catch (IOException e) {
                    System.err.println("File broken");
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Couldn't read file:" + e.getLocalizedMessage(), "Error reading file", 0);
                    break block15;
                }
                AnalysisRunner runner = new AnalysisRunner(sequenceFile);
                ResultsPanel rp = new ResultsPanel(sequenceFile);
                runner.addAnalysisListener(rp);
                this.fileTabs.addTab(sequenceFile.name(), rp);
                OverRepresentedSeqs os = new OverRepresentedSeqs();
                QCModule[] module_list = new QCModule[]{new BasicStats(), new PerBaseQualityScores(), new PerTileQualityScores(), new PerSequenceQualityScores(), new PerBaseSequenceContent(), new PerSequenceGCContent(), new NContent(), new SequenceLengthDistribution(), os.duplicationLevelModule(), os, new AdapterContent(), new KmerContent()};
                runner.startAnalysis(module_list);
            }
            ++i;
        }
    }

    public void saveReport() {
        int reply;
        File reportFile;
        JFileChooser chooser = this.lastUsedDir == null ? new JFileChooser() : new JFileChooser(this.lastUsedDir);
        if (this.fileTabs.getSelectedComponent() == null) {
            JOptionPane.showMessageDialog(this, "No FastQ files are open yet", "Can't save report", 0);
            return;
        }
        chooser.setSelectedFile(new File(String.valueOf(((ResultsPanel)this.fileTabs.getSelectedComponent()).sequenceFile().getFile().getName().replaceAll(".gz$", "").replaceAll(".bz2$", "").replaceAll(".txt$", "").replaceAll(".fastq$", "").replaceAll(".fq$", "").replaceAll(".sam$", "").replaceAll(".bam$", "")) + "_fastqc.html"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "HTML files";
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".html");
            }
        });
        do {
            int result;
            if ((result = chooser.showSaveDialog(this)) == 1) {
                return;
            }
            reportFile = chooser.getSelectedFile();
            if (reportFile.getName().toLowerCase().endsWith(".html")) continue;
            reportFile = new File(reportFile.getAbsoluteFile() + ".html");
        } while (reportFile.exists() && (reply = JOptionPane.showConfirmDialog(this, String.valueOf(reportFile.getName()) + " already exists.  Overwrite?", "Overwrite existing file?", 0)) == 1);
        ResultsPanel selectedPanel = (ResultsPanel)this.fileTabs.getSelectedComponent();
        try {
            new HTMLReportArchive(selectedPanel.sequenceFile(), selectedPanel.modules(), reportFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to create archive: " + e.getMessage(), "Error", 0);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (System.getProperty("fastqc.show_version") != null && System.getProperty("fastqc.show_version").equals("true")) {
            System.out.println("FastQC v0.11.2");
            System.exit(0);
        }
        if (args.length > 0) {
            System.setProperty("java.awt.headless", "true");
            if (FastQCConfig.getInstance().do_unzip == null) {
                FastQCConfig.getInstance().do_unzip = false;
            }
            new OfflineRunner(args);
            System.exit(0);
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (FastQCConfig.getInstance().do_unzip == null) {
                FastQCConfig.getInstance().do_unzip = false;
            }
            FastQCApplication app = new FastQCApplication();
            app.setVisible(true);
        }
    }
}

