/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Help;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import uk.ac.babraham.FastQC.Help.HelpPage;

public class HelpIndexRoot
extends DefaultMutableTreeNode {
    public FileSorter fs = new FileSorter();

    public HelpIndexRoot(File startingLocation) {
        super("Help Contents");
        if (!startingLocation.exists() || !startingLocation.isDirectory()) {
            throw new IllegalArgumentException("Couldn't find help file directory at '" + startingLocation.getAbsolutePath() + "'");
        }
        this.addSubfiles(startingLocation, this);
    }

    private void addSubfiles(File directory, DefaultMutableTreeNode node) {
        File[] files = directory.listFiles();
        Arrays.sort(files, this.fs);
        int f = 0;
        while (f < files.length) {
            HelpPage h;
            if (files[f].isDirectory()) {
                h = new HelpPage(files[f]);
                node.add(h);
                this.addSubfiles(files[f], h);
            } else if (files[f].getName().toLowerCase().endsWith(".html") || files[f].getName().toLowerCase().endsWith(".htm")) {
                h = new HelpPage(files[f]);
                node.add(h);
            }
            ++f;
        }
    }

    public HelpPage[] findPagesForTerm(String searchTerm) throws IOException {
        Vector<HelpPage> hits = new Vector<HelpPage>();
        Enumeration<TreeNode> kids = this.children();
        while (kids.hasMoreElements()) {
            TreeNode node = kids.nextElement();
            if (!(node instanceof HelpPage)) continue;
            ((HelpPage)node).containsString(searchTerm, hits);
        }
        return hits.toArray(new HelpPage[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileSorter
    implements Comparator<File> {
        private FileSorter() {
        }

        @Override
        public int compare(File f1, File f2) {
            int[] numbers2;
            int[] numbers1;
            try {
                numbers1 = this.getNumberArray(f1);
                numbers2 = this.getNumberArray(f2);
            }
            catch (NumberFormatException nfe) {
                return f1.getName().compareTo(f2.getName());
            }
            int shortest = numbers1.length;
            if (numbers2.length < shortest) {
                shortest = numbers2.length;
            }
            int i = 0;
            while (i < shortest) {
                if (numbers1[i] != numbers2[i]) {
                    return numbers1[i] - numbers2[i];
                }
                ++i;
            }
            return numbers1.length - numbers2.length;
        }

        private int[] getNumberArray(File f) throws NumberFormatException {
            String[] numberStrings = f.getName().split(" ")[0].split("\\.");
            int[] ints = new int[numberStrings.length];
            int i = 0;
            while (i < numberStrings.length) {
                ints[i] = Integer.parseInt(numberStrings[i]);
                ++i;
            }
            return ints;
        }
    }
}

