/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.babraham.FastQC.Help.HelpDialog;
import uk.ac.babraham.FastQC.Help.HelpIndexRoot;
import uk.ac.babraham.FastQC.Help.HelpPage;

public class HelpSearchPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
Runnable {
    private HelpIndexRoot root;
    private JTextField queryField;
    private JList resultList;
    private DefaultListModel listModel;
    private JButton searchButton;
    private HelpDialog dialog;
    private JScrollPane resultsScrollPane;

    public HelpSearchPanel(HelpIndexRoot root, HelpDialog dialog) {
        this.root = root;
        this.dialog = dialog;
        this.setLayout(new BorderLayout());
        JPanel queryPanel = new JPanel();
        queryPanel.setLayout(new BorderLayout());
        queryPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.queryField = new JTextField();
        this.queryField.setActionCommand("search");
        this.queryField.addActionListener(this);
        queryPanel.add((Component)this.queryField, "Center");
        this.searchButton = new JButton("Search");
        this.searchButton.setActionCommand("search");
        this.searchButton.addActionListener(this);
        queryPanel.add((Component)this.searchButton, "East");
        this.add((Component)queryPanel, "North");
        this.listModel = new DefaultListModel();
        this.listModel.addElement("[No search results]");
        this.resultList = new JList(this.listModel);
        this.resultList.addListSelectionListener(this);
        this.resultList.setSelectionMode(0);
        this.resultsScrollPane = new JScrollPane(this.resultList);
        this.add((Component)this.resultsScrollPane, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        Thread t = new Thread(this);
        t.start();
    }

    public void valueChanged(ListSelectionEvent lse) {
        Object o = this.resultList.getSelectedValue();
        if (o != null && o instanceof HelpPage) {
            this.dialog.DisplayPage((HelpPage)o);
        }
    }

    public void run() {
        this.searchButton.setEnabled(false);
        this.listModel.removeAllElements();
        if (this.queryField.getText().trim().length() > 0) {
            HelpPage[] results;
            try {
                results = this.root.findPagesForTerm(this.queryField.getText().trim());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.searchButton.setEnabled(true);
                return;
            }
            if (results.length > 0) {
                int r = 0;
                while (r < results.length) {
                    this.listModel.addElement(results[r]);
                    ++r;
                }
            } else {
                this.listModel.addElement("[No search results]");
            }
        }
        this.remove(this.resultsScrollPane);
        this.revalidate();
        this.resultList = new JList(this.listModel);
        this.resultList.addListSelectionListener(this);
        this.resultsScrollPane = new JScrollPane(this.resultList);
        this.add((Component)this.resultsScrollPane, "Center");
        this.revalidate();
        this.repaint();
        this.searchButton.setEnabled(true);
    }
}

