/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.QualityEncoding.PhredEncoding;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class BasicStats
extends AbstractQCModule {
    private String name = null;
    private long actualCount = 0L;
    private long filteredCount = 0L;
    private int minLength = 0;
    private int maxLength = 0;
    private long gCount = 0L;
    private long cCount = 0L;
    private long aCount = 0L;
    private long tCount = 0L;
    private long nCount = 0L;
    private char lowestChar = (char)126;
    private String fileType = null;

    public String description() {
        return "Calculates some basic statistics about the file";
    }

    public boolean ignoreFilteredSequences() {
        return false;
    }

    public JPanel getResultsPanel() {
        JPanel returnPanel = new JPanel();
        returnPanel.setLayout(new BorderLayout());
        returnPanel.add((Component)new JLabel("Basic sequence stats", 0), "North");
        ResultsTable model = new ResultsTable();
        returnPanel.add((Component)new JScrollPane(new JTable(model)), "Center");
        return returnPanel;
    }

    public void reset() {
        this.minLength = 0;
        this.maxLength = 0;
        this.gCount = 0L;
        this.cCount = 0L;
        this.aCount = 0L;
        this.tCount = 0L;
        this.nCount = 0L;
    }

    public String name() {
        return "Basic Statistics";
    }

    public void processSequence(Sequence sequence) {
        if (this.name == null) {
            this.name = sequence.file().name();
        }
        if (sequence.isFiltered()) {
            ++this.filteredCount;
            return;
        }
        ++this.actualCount;
        if (this.fileType == null) {
            this.fileType = sequence.getColorspace() != null ? "Colorspace converted to bases" : "Conventional base calls";
        }
        if (this.actualCount == 1L) {
            this.minLength = sequence.getSequence().length();
            this.maxLength = sequence.getSequence().length();
        } else {
            if (sequence.getSequence().length() < this.minLength) {
                this.minLength = sequence.getSequence().length();
            }
            if (sequence.getSequence().length() > this.maxLength) {
                this.maxLength = sequence.getSequence().length();
            }
        }
        char[] chars = sequence.getSequence().toCharArray();
        int c = 0;
        while (c < chars.length) {
            switch (chars[c]) {
                case 'G': {
                    ++this.gCount;
                    break;
                }
                case 'A': {
                    ++this.aCount;
                    break;
                }
                case 'T': {
                    ++this.tCount;
                    break;
                }
                case 'C': {
                    ++this.cCount;
                    break;
                }
                case 'N': {
                    ++this.nCount;
                }
            }
            ++c;
        }
        chars = sequence.getQualityString().toCharArray();
        c = 0;
        while (c < chars.length) {
            if (chars[c] < this.lowestChar) {
                this.lowestChar = chars[c];
            }
            ++c;
        }
    }

    public boolean raisesError() {
        return false;
    }

    public boolean raisesWarning() {
        return false;
    }

    public boolean ignoreInReport() {
        return false;
    }

    public void makeReport(HTMLReportArchive report) throws XMLStreamException, IOException {
        super.writeTable(report, new ResultsTable());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultsTable
    extends AbstractTableModel {
        private String[] rowNames = new String[]{"Filename", "File type", "Encoding", "Total Sequences", "Sequences flagged as poor quality", "Sequence length", "%GC"};

        private ResultsTable() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.rowNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.rowNames[rowIndex];
                }
                case 1: {
                    switch (rowIndex) {
                        case 0: {
                            return BasicStats.this.name;
                        }
                        case 1: {
                            return BasicStats.this.fileType;
                        }
                        case 2: {
                            return PhredEncoding.getFastQEncodingOffset(BasicStats.this.lowestChar);
                        }
                        case 3: {
                            return "" + BasicStats.this.actualCount;
                        }
                        case 4: {
                            return "" + BasicStats.this.filteredCount;
                        }
                        case 5: {
                            if (BasicStats.this.minLength == BasicStats.this.maxLength) {
                                return "" + BasicStats.this.minLength;
                            }
                            return String.valueOf(BasicStats.this.minLength) + "-" + BasicStats.this.maxLength;
                        }
                        case 6: {
                            if (BasicStats.this.aCount + BasicStats.this.tCount + BasicStats.this.gCount + BasicStats.this.cCount > 0L) {
                                return "" + (BasicStats.this.gCount + BasicStats.this.cCount) * 100L / (BasicStats.this.aCount + BasicStats.this.tCount + BasicStats.this.gCount + BasicStats.this.cCount);
                            }
                            return 0;
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Measure";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }
    }
}

