/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.math3.distribution.BinomialDistribution;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Graphs.BaseGroup;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class KmerContent
extends AbstractQCModule {
    private Hashtable<String, Kmer> kmers = new Hashtable((int)Math.pow(4.0, MAX_KMER_SIZE));
    private int longestSequence = 0;
    private long[][] totalKmerCounts = new long[0][0];
    private long skipCount = 0L;
    private static int MIN_KMER_SIZE = 7;
    private static int MAX_KMER_SIZE = 7;
    public boolean calculated = false;
    private Kmer[] enrichedKmers = null;
    private double[][] enrichments = null;
    private double minGraphValue = 0.0;
    private double maxGraphValue = 0.0;
    private String[] xCategories = new String[0];
    private String[] xLabels = new String[0];
    BaseGroup[] groups;

    public KmerContent() {
        if (FastQCConfig.getInstance().kmer_size != null) {
            int kmerSize;
            MIN_KMER_SIZE = kmerSize = FastQCConfig.getInstance().kmer_size.intValue();
            MAX_KMER_SIZE = kmerSize;
        }
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("kmer", "ignore") > 0.0;
    }

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.calculateEnrichment();
        }
        JPanel returnPanel = new JPanel();
        returnPanel.setLayout(new BorderLayout());
        returnPanel.add((Component)new JLabel("Overrepresented Kmers", 0), "North");
        JSplitPane splitPanel = new JSplitPane(0);
        if (this.enrichedKmers.length > 0) {
            ResultsTable model = new ResultsTable(this.enrichedKmers);
            splitPanel.setBottomComponent(new JScrollPane(new JTable(model)));
            splitPanel.setTopComponent(new LineGraph(this.enrichments, this.minGraphValue, this.maxGraphValue, "Position in read (bp)", this.xLabels, this.xCategories, "Log2 Obs/Exp"));
            returnPanel.add((Component)splitPanel, "Center");
        } else {
            returnPanel.add((Component)new JLabel("There are no overrepresented Kmers", 0), "Center");
        }
        return returnPanel;
    }

    private void addKmerCount(int position, int kmerLength, String kmer) {
        if (position >= this.totalKmerCounts.length) {
            long[][] newCounts = new long[position + 1][];
            int i = 0;
            while (i < this.totalKmerCounts.length) {
                newCounts[i] = this.totalKmerCounts[i];
                ++i;
            }
            i = this.totalKmerCounts.length;
            while (i < newCounts.length) {
                newCounts[i] = new long[MAX_KMER_SIZE];
                ++i;
            }
            this.totalKmerCounts = newCounts;
        }
        if (kmer.indexOf("N") >= 0) {
            return;
        }
        long[] lArray = this.totalKmerCounts[position];
        int n = kmerLength - 1;
        lArray[n] = lArray[n] + 1L;
    }

    private synchronized void calculateEnrichment() {
        this.groups = BaseGroup.makeBaseGroups(this.longestSequence - MIN_KMER_SIZE + 1);
        Vector<Kmer> unevenKmers = new Vector<Kmer>();
        for (Kmer k : this.kmers.values()) {
            char[] chars = k.sequence().toCharArray();
            long totalKmerCount = 0L;
            int i = 0;
            while (i < this.totalKmerCounts.length) {
                totalKmerCount += this.totalKmerCounts[i][k.sequence().length() - 1];
                ++i;
            }
            float expectedProportion = (float)k.count / (float)totalKmerCount;
            float[] obsExpPositions = new float[this.groups.length];
            float[] binomialPValues = new float[this.groups.length];
            long[] positionCounts = k.getPositions();
            int g = 0;
            while (g < this.groups.length) {
                long totalGroupCount = 0L;
                long totalGroupHits = 0L;
                int p = this.groups[g].lowerCount() - 1;
                while (p < this.groups[g].upperCount() && p < positionCounts.length) {
                    totalGroupCount += this.totalKmerCounts[p][chars.length - 1];
                    totalGroupHits += positionCounts[p];
                    ++p;
                }
                float predicted = expectedProportion * (float)totalGroupCount;
                obsExpPositions[g] = (float)totalGroupHits / predicted;
                BinomialDistribution bd = new BinomialDistribution((int)totalGroupCount, expectedProportion);
                binomialPValues[g] = (float)totalGroupHits > predicted ? (float)((1.0 - bd.cumulativeProbability((int)totalGroupHits)) * Math.pow(4.0, chars.length)) : 1.0f;
                ++g;
            }
            k.setObsExpPositions(obsExpPositions);
            float lowestPValue = 1.0f;
            int i2 = 0;
            while (i2 < binomialPValues.length) {
                if ((double)binomialPValues[i2] < 0.01 && obsExpPositions[i2] > 5.0f && binomialPValues[i2] < lowestPValue) {
                    lowestPValue = binomialPValues[i2];
                }
                ++i2;
            }
            if (!((double)lowestPValue < 0.01)) continue;
            k.setLowestPValue(lowestPValue);
            unevenKmers.add(k);
        }
        Object[] finalKMers = unevenKmers.toArray(new Kmer[0]);
        Arrays.sort(finalKMers);
        if (finalKMers.length > 20) {
            Kmer[] shortenedKmers = new Kmer[20];
            int i = 0;
            while (i < shortenedKmers.length) {
                shortenedKmers[i] = finalKMers[i];
                ++i;
            }
            finalKMers = shortenedKmers;
        }
        this.enrichments = new double[Math.min(6, finalKMers.length)][];
        this.xLabels = new String[this.enrichments.length];
        this.xCategories = new String[this.groups.length];
        int i = 0;
        while (i < this.xCategories.length) {
            this.xCategories[i] = this.groups[i].toString();
            ++i;
        }
        int k = 0;
        while (k < this.enrichments.length) {
            this.enrichments[k] = new double[this.groups.length];
            float[] obsExpPos = ((Kmer)finalKMers[k]).getObsExpPositions();
            int g = 0;
            while (g < this.groups.length) {
                this.enrichments[k][g] = obsExpPos[g];
                if ((double)obsExpPos[g] > this.maxGraphValue) {
                    this.maxGraphValue = obsExpPos[g];
                }
                if ((double)obsExpPos[g] < this.minGraphValue) {
                    this.minGraphValue = obsExpPos[g];
                }
                ++g;
            }
            this.xLabels[k] = ((Kmer)finalKMers[k]).sequence();
            ++k;
        }
        this.minGraphValue = 0.0;
        this.enrichedKmers = finalKMers;
        this.calculated = true;
    }

    public void processSequence(Sequence sequence) {
        this.calculated = false;
        ++this.skipCount;
        if (this.skipCount % 50L != 0L) {
            return;
        }
        String seq = sequence.getSequence().length() > 500 ? sequence.getSequence().substring(0, 500) : sequence.getSequence();
        if (seq.length() > this.longestSequence) {
            this.longestSequence = seq.length();
        }
        int kmerSize = MIN_KMER_SIZE;
        while (kmerSize <= MAX_KMER_SIZE) {
            int i = 0;
            while (i <= seq.length() - kmerSize) {
                String kmer = seq.substring(i, i + kmerSize);
                if (kmer.length() != kmerSize) {
                    throw new IllegalStateException("String length " + kmer.length() + " wasn't the same as the kmer length " + kmerSize);
                }
                this.addKmerCount(i, kmerSize, kmer);
                if (kmer.indexOf("N") < 0) {
                    if (this.kmers.containsKey(kmer)) {
                        this.kmers.get(kmer).incrementCount(i);
                    } else {
                        this.kmers.put(new String(kmer), new Kmer(kmer, i, seq.length() - kmerSize + 1));
                    }
                }
                ++i;
            }
            ++kmerSize;
        }
    }

    public void reset() {
        this.calculated = false;
        this.totalKmerCounts = new long[0][0];
        this.longestSequence = 0;
        this.skipCount = 0L;
        this.enrichedKmers = null;
        this.kmers.clear();
    }

    public String description() {
        return "Identifies short sequences which have uneven representation";
    }

    public String name() {
        return "Kmer Content";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.calculateEnrichment();
        }
        return this.enrichedKmers.length > 0 && 0.0 - Math.log10(this.enrichedKmers[0].pValue()) > ModuleConfig.getParam("kmer", "error");
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.calculateEnrichment();
        }
        return this.enrichedKmers.length > 0 && 0.0 - Math.log10(this.enrichedKmers[0].pValue()) > ModuleConfig.getParam("kmer", "warn");
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (!this.calculated) {
            this.calculateEnrichment();
        }
        if (this.enrichedKmers.length > 0) {
            ZipOutputStream zip = report.zipFile();
            zip.putNextEntry(new ZipEntry(String.valueOf(report.folderName()) + "/Images/kmer_profiles.png"));
            BufferedImage b = new BufferedImage(Math.max(800, this.groups.length * 15), 600, 1);
            Graphics g = b.getGraphics();
            LineGraph lg = new LineGraph(this.enrichments, this.minGraphValue, this.maxGraphValue, "Position in read (bp)", this.xLabels, this.xCategories, "Log2 Obs/Exp");
            lg.paint(g, b.getWidth(), b.getHeight());
            ImageIO.write((RenderedImage)b, "PNG", zip);
            zip.closeEntry();
            super.simpleXhtmlReport(report, b, "Kmer graph");
        }
        ResultsTable table = new ResultsTable(this.enrichedKmers);
        XMLStreamWriter xhtml = report.xhtmlStream();
        if (this.enrichedKmers.length == 0) {
            xhtml.writeStartElement("p");
            xhtml.writeCharacters("No overrepresented Kmers");
            xhtml.writeEndElement();
        } else {
            super.writeTable(report, table);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Kmer
    implements Comparable<Kmer> {
        private String sequence;
        private long count = 0L;
        private float lowestPValue = 0.0f;
        private float[] obsExpPositions = null;
        private long[] positions = new long[0];

        public Kmer(String sequence, int position, int seqLength) {
            char[] chars = sequence.toCharArray();
            this.sequence = new String(chars);
            this.count = 1L;
            this.positions = new long[seqLength];
            int n = position;
            this.positions[n] = this.positions[n] + 1L;
        }

        public void incrementCount(int position) {
            ++this.count;
            if (position >= this.positions.length) {
                long[] newPositions = new long[position + 1];
                int i = 0;
                while (i < this.positions.length) {
                    newPositions[i] = this.positions[i];
                    ++i;
                }
                this.positions = newPositions;
            }
            int n = position;
            this.positions[n] = this.positions[n] + 1L;
        }

        public long[] getPositions() {
            return this.positions;
        }

        public String sequence() {
            return this.sequence;
        }

        public long count() {
            return this.count;
        }

        public void setLowestPValue(float p) {
            this.lowestPValue = p;
        }

        public void setObsExpPositions(float[] oePositions) {
            this.obsExpPositions = oePositions;
        }

        public float[] getObsExpPositions() {
            return this.obsExpPositions;
        }

        public float pValue() {
            return this.lowestPValue;
        }

        public float maxObsExp() {
            float max = 0.0f;
            int i = 0;
            while (i < this.obsExpPositions.length) {
                if (this.obsExpPositions[i] > max) {
                    max = this.obsExpPositions[i];
                }
                ++i;
            }
            return max;
        }

        public int maxPosition() {
            float max = 0.0f;
            int position = 0;
            int i = 0;
            while (i < this.obsExpPositions.length) {
                if (this.obsExpPositions[i] > max) {
                    max = this.obsExpPositions[i];
                    position = i + 1;
                }
                ++i;
            }
            if (position == 0) {
                System.err.println("No value > 0 for " + this.sequence);
                position = 1;
            }
            return position;
        }

        @Override
        public int compareTo(Kmer o) {
            return Float.compare(o.maxObsExp(), this.maxObsExp());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultsTable
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private Kmer[] kmers;

        public ResultsTable(Kmer[] kmers) {
            this.kmers = kmers;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.kmers.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.kmers[rowIndex].sequence();
                }
                case 1: {
                    return this.kmers[rowIndex].count() * 5L;
                }
                case 2: {
                    return Float.valueOf(this.kmers[rowIndex].pValue());
                }
                case 3: {
                    return Float.valueOf(this.kmers[rowIndex].maxObsExp());
                }
                case 4: {
                    return KmerContent.this.groups[this.kmers[rowIndex].maxPosition() - 1].toString();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Sequence";
                }
                case 1: {
                    return "Count";
                }
                case 2: {
                    return "PValue";
                }
                case 3: {
                    return "Obs/Exp Max";
                }
                case 4: {
                    return "Max Obs/Exp Position";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Float.class;
                }
                case 3: {
                    return Float.class;
                }
                case 4: {
                    return String.class;
                }
            }
            return null;
        }
    }
}

