/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Graphs.BaseGroup;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class NContent
extends AbstractQCModule {
    public long[] nCounts = new long[0];
    public long[] notNCounts = new long[0];
    public boolean calculated = false;
    public double[] percentages = null;
    public String[] xCategories = new String[0];

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.getPercentages();
        }
        return new LineGraph((double[][])new double[][]{this.percentages}, 0.0, 100.0, "Position in read (bp)", new String[]{"%N"}, this.xCategories, "N content across all bases");
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("n_content", "ignore") > 0.0;
    }

    private synchronized void getPercentages() {
        BaseGroup[] groups = BaseGroup.makeBaseGroups(this.nCounts.length);
        this.xCategories = new String[groups.length];
        this.percentages = new double[groups.length];
        int i = 0;
        while (i < groups.length) {
            this.xCategories[i] = groups[i].toString();
            long nCount = 0L;
            long total = 0L;
            int bp = groups[i].lowerCount() - 1;
            while (bp < groups[i].upperCount()) {
                nCount += this.nCounts[bp];
                total += this.nCounts[bp];
                total += this.notNCounts[bp];
                ++bp;
            }
            this.percentages[i] = 100.0 * ((double)nCount / (double)total);
            ++i;
        }
        this.calculated = true;
    }

    public void processSequence(Sequence sequence) {
        this.calculated = false;
        char[] seq = sequence.getSequence().toCharArray();
        if (this.nCounts.length < seq.length) {
            long[] nCountsNew = new long[seq.length];
            long[] notNCountsNew = new long[seq.length];
            int i = 0;
            while (i < this.nCounts.length) {
                nCountsNew[i] = this.nCounts[i];
                notNCountsNew[i] = this.notNCounts[i];
                ++i;
            }
            this.nCounts = nCountsNew;
            this.notNCounts = notNCountsNew;
        }
        int i = 0;
        while (i < seq.length) {
            if (seq[i] == 'N') {
                int n = i;
                this.nCounts[n] = this.nCounts[n] + 1L;
            } else {
                int n = i;
                this.notNCounts[n] = this.notNCounts[n] + 1L;
            }
            ++i;
        }
    }

    public void reset() {
        this.nCounts = new long[0];
        this.notNCounts = new long[0];
    }

    public String description() {
        return "Shows the percentage of bases at each position which are not being called";
    }

    public String name() {
        return "Per base N content";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.getPercentages();
        }
        int i = 0;
        while (i < this.percentages.length) {
            if (this.percentages[i] > ModuleConfig.getParam("n_content", "error")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.getPercentages();
        }
        int i = 0;
        while (i < this.percentages.length) {
            if (this.percentages[i] > ModuleConfig.getParam("n_content", "warn")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void makeReport(HTMLReportArchive report) throws XMLStreamException, IOException {
        if (!this.calculated) {
            this.getPercentages();
        }
        ZipOutputStream zip = report.zipFile();
        zip.putNextEntry(new ZipEntry(String.valueOf(report.folderName()) + "/Images/per_base_n_content.png"));
        BufferedImage b = new BufferedImage(Math.max(800, this.percentages.length * 15), 600, 1);
        Graphics g = b.getGraphics();
        LineGraph lg = new LineGraph((double[][])new double[][]{this.percentages}, 0.0, 100.0, "Position in read (bp)", new String[]{"%N"}, this.xCategories, "N content across all bases");
        lg.paint(g, b.getWidth(), b.getHeight());
        ImageIO.write((RenderedImage)b, "PNG", zip);
        zip.closeEntry();
        super.simpleXhtmlReport(report, b, "N content graph");
        StringBuffer sb = report.dataDocument();
        sb.append("#Base\tN-Count\n");
        int i = 0;
        while (i < this.xCategories.length) {
            sb.append(this.xCategories[i]);
            sb.append("\t");
            sb.append(this.percentages[i]);
            sb.append("\n");
            ++i;
        }
    }
}

