/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Results;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.babraham.FastQC.Analysis.AnalysisListener;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;

public class ResultsPanel
extends JPanel
implements ListSelectionListener,
AnalysisListener {
    private static final ImageIcon ERROR_ICON = new ImageIcon(ClassLoader.getSystemResource("uk/ac/babraham/FastQC/Resources/error.png"));
    private static final ImageIcon WARNING_ICON = new ImageIcon(ClassLoader.getSystemResource("uk/ac/babraham/FastQC/Resources/warning.png"));
    private static final ImageIcon OK_ICON = new ImageIcon(ClassLoader.getSystemResource("uk/ac/babraham/FastQC/Resources/tick.png"));
    private QCModule[] modules;
    private JList moduleList;
    private JPanel[] panels;
    private JPanel currentPanel = null;
    private JLabel progressLabel;
    private SequenceFile sequenceFile;

    public ResultsPanel(SequenceFile sequenceFile) {
        this.sequenceFile = sequenceFile;
        this.setLayout(new BorderLayout());
        this.progressLabel = new JLabel("Waiting to start...", 0);
        this.add((Component)this.progressLabel, "Center");
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.moduleList.getSelectedIndex();
        if (index >= 0) {
            this.remove(this.currentPanel);
            this.currentPanel = this.panels[index];
            this.add((Component)this.currentPanel, "Center");
            this.validate();
            this.repaint();
        }
    }

    public SequenceFile sequenceFile() {
        return this.sequenceFile;
    }

    public QCModule[] modules() {
        return this.modules;
    }

    public void analysisComplete(SequenceFile file, QCModule[] rawModules) {
        this.remove(this.progressLabel);
        Vector<QCModule> modulesToDisplay = new Vector<QCModule>();
        int m = 0;
        while (m < rawModules.length) {
            if (!rawModules[m].ignoreInReport()) {
                modulesToDisplay.add(rawModules[m]);
            }
            ++m;
        }
        this.modules = modulesToDisplay.toArray(new QCModule[0]);
        this.panels = new JPanel[this.modules.length];
        m = 0;
        while (m < this.modules.length) {
            this.panels[m] = this.modules[m].getResultsPanel();
            ++m;
        }
        this.moduleList = new JList<QCModule>(this.modules);
        this.moduleList.setCellRenderer(new ModuleRenderer());
        this.moduleList.setSelectionMode(0);
        this.moduleList.setSelectedIndex(0);
        this.moduleList.addListSelectionListener(this);
        this.add((Component)new JScrollPane(this.moduleList), "West");
        this.currentPanel = this.panels[0];
        this.add((Component)this.currentPanel, "Center");
        this.validate();
    }

    public void analysisUpdated(SequenceFile file, int sequencesProcessed, int percentComplete) {
        if (percentComplete > 99) {
            this.progressLabel.setText("Read " + sequencesProcessed + " sequences");
        } else {
            this.progressLabel.setText("Read " + sequencesProcessed + " sequences (" + percentComplete + "%)");
        }
    }

    public void analysisExceptionReceived(SequenceFile file, Exception e) {
        this.progressLabel.setText("Failed to process file: " + e.getLocalizedMessage());
    }

    public void analysisStarted(SequenceFile file) {
        this.progressLabel.setText("Starting analysis...");
    }

    private class ModuleRenderer
    extends DefaultListCellRenderer {
        private ModuleRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof QCModule)) {
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            QCModule module = (QCModule)value;
            ImageIcon icon = OK_ICON;
            if (module.raisesError()) {
                icon = ERROR_ICON;
            } else if (module.raisesWarning()) {
                icon = WARNING_ICON;
            }
            JLabel returnLabel = new JLabel(module.name(), icon, 2);
            returnLabel.setOpaque(true);
            if (isSelected) {
                returnLabel.setBackground(Color.LIGHT_GRAY);
            } else {
                returnLabel.setBackground(Color.WHITE);
            }
            return returnLabel;
        }
    }
}

