/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;

public class BAMFile
implements SequenceFile {
    private File file;
    private boolean onlyMapped;
    private long fileSize = 0L;
    private long recordSize = 0L;
    private FileInputStream fis;
    private SAMFileReader br;
    private String name;
    private Sequence nextSequence = null;
    Iterator<SAMRecord> it;

    protected BAMFile(File file, boolean onlyMapped) throws SequenceFormatException, IOException {
        this.file = file;
        this.fileSize = file.length();
        this.name = file.getName();
        this.onlyMapped = onlyMapped;
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        this.fis = new FileInputStream(file);
        this.br = new SAMFileReader((InputStream)this.fis);
        this.it = this.br.iterator();
        this.readNext();
    }

    public String name() {
        return this.name;
    }

    public int getPercentComplete() {
        if (!this.hasNext()) {
            return 100;
        }
        try {
            int percent = (int)((double)this.fis.getChannel().position() / (double)this.fileSize * 100.0);
            return percent;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isColorspace() {
        return false;
    }

    public boolean hasNext() {
        return this.nextSequence != null;
    }

    public Sequence next() throws SequenceFormatException {
        Sequence returnSeq = this.nextSequence;
        this.readNext();
        return returnSeq;
    }

    private void readNext() throws SequenceFormatException {
        SAMRecord record;
        do {
            if (!this.it.hasNext()) {
                this.nextSequence = null;
                try {
                    this.br.close();
                    this.fis.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return;
            }
            try {
                record = this.it.next();
            }
            catch (SAMFormatException sfe) {
                throw new SequenceFormatException(sfe.getMessage());
            }
        } while (this.onlyMapped && record.getReadUnmappedFlag());
        if (this.recordSize == 0L) {
            this.recordSize = record.getReadLength() * 2 + 150;
            if (this.br.isBinary()) {
                this.recordSize /= 4L;
            }
        }
        String sequence = record.getReadString();
        String qualities = record.getBaseQualityString();
        if (qualities.length() == 1 && sequence.length() != 1 && qualities.equals("*")) {
            qualities = "";
        }
        if (record.getReadNegativeStrandFlag()) {
            sequence = this.reverseComplement(sequence);
            qualities = this.reverse(qualities);
        }
        this.nextSequence = new Sequence(this, sequence, qualities, record.getReadName());
    }

    private String reverseComplement(String sequence) {
        char[] letters = this.reverse(sequence).toUpperCase().toCharArray();
        char[] rc = new char[letters.length];
        int i = 0;
        while (i < letters.length) {
            switch (letters[i]) {
                case 'G': {
                    rc[i] = 67;
                    break;
                }
                case 'A': {
                    rc[i] = 84;
                    break;
                }
                case 'T': {
                    rc[i] = 65;
                    break;
                }
                case 'C': {
                    rc[i] = 71;
                    break;
                }
                default: {
                    rc[i] = letters[i];
                }
            }
            ++i;
        }
        return new String(rc);
    }

    private String reverse(String sequence) {
        char[] starting = sequence.toCharArray();
        char[] reversed = new char[starting.length];
        int i = 0;
        while (i < starting.length) {
            reversed[reversed.length - (1 + i)] = starting[i];
            ++i;
        }
        return new String(reversed);
    }

    public File getFile() {
        return this.file;
    }
}

