/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence.Contaminant;

import uk.ac.babraham.FastQC.Sequence.Contaminant.ContaminantHit;

public class Contaminant {
    private String name;
    private char[] forward;
    private char[] reverse;

    public Contaminant(String name, String sequence) {
        this.name = name;
        sequence = sequence.toUpperCase();
        this.forward = sequence.toCharArray();
        this.reverse = new char[this.forward.length];
        int c = 0;
        while (c < this.forward.length) {
            int revPos = this.reverse.length - 1 - c;
            switch (this.forward[c]) {
                case 'G': {
                    this.reverse[revPos] = 67;
                    break;
                }
                case 'A': {
                    this.reverse[revPos] = 84;
                    break;
                }
                case 'T': {
                    this.reverse[revPos] = 65;
                    break;
                }
                case 'C': {
                    this.reverse[revPos] = 71;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Contaminant contained the illegal character '" + this.forward[c] + "'");
                }
            }
            ++c;
        }
    }

    public ContaminantHit findMatch(String query) {
        ContaminantHit thisHit;
        if ((query = query.toUpperCase()).length() < 20 && query.length() >= 8) {
            if (new String(this.forward).contains(query)) {
                return new ContaminantHit(this, 1, query.length(), 100);
            }
            if (new String(this.reverse).contains(query)) {
                return new ContaminantHit(this, 2, query.length(), 100);
            }
        }
        char[] q = query.toCharArray();
        ContaminantHit bestHit = null;
        int offset = 0 - (this.forward.length - 20);
        while (offset < q.length - 20) {
            thisHit = this.findMatch(this.forward, q, offset, 1);
            if (thisHit != null && (bestHit == null || thisHit.length() > bestHit.length())) {
                bestHit = thisHit;
            }
            ++offset;
        }
        offset = 0 - (this.forward.length - 20);
        while (offset < q.length - 20) {
            thisHit = this.findMatch(this.reverse, q, offset, 2);
            if (thisHit != null && (bestHit == null || thisHit.length() > bestHit.length())) {
                bestHit = thisHit;
            }
            ++offset;
        }
        return bestHit;
    }

    private ContaminantHit findMatch(char[] ca, char[] cb, int offset, int direction) {
        ContaminantHit bestHit = null;
        int mismatchCount = 0;
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < ca.length) {
            if (i + offset < 0) {
                start = i + 1;
            } else {
                if (i + offset >= cb.length) break;
                if (ca[i] == cb[i + offset]) {
                    end = i;
                } else if (++mismatchCount > 1) {
                    if (1 + (end - start) > 20) {
                        int id = (1 + (end - start) - (mismatchCount - 1)) * 100 / (1 + (end - start));
                        if (bestHit == null || bestHit.length() < 1 + (end - start) || bestHit.length() == 1 + (end - start) && bestHit.percentID() < id) {
                            bestHit = new ContaminantHit(this, direction, 1 + (end - start), id);
                        }
                    }
                    start = i + 1;
                    end = i + 1;
                    mismatchCount = 0;
                }
            }
            ++i;
        }
        if (1 + (end - start) > 20) {
            int id = (1 + (end - start) - mismatchCount) * 100 / (1 + (end - start));
            if (bestHit == null || bestHit.length() < 1 + (end - start) || bestHit.length() == 1 + (end - start) && bestHit.percentID() < id) {
                bestHit = new ContaminantHit(this, direction, 1 + (end - start), id);
            }
        }
        return bestHit;
    }

    public String name() {
        return this.name;
    }
}

