/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence.Contaminant;

import uk.ac.babraham.FastQC.Sequence.Contaminant.Contaminant;

public class ContaminantHit {
    private Contaminant contaminant;
    private int direction;
    private int length;
    private int percentID;
    public static final int FORWARD = 1;
    public static final int REVERSE = 2;

    public ContaminantHit(Contaminant contaminant, int direction, int length, int percentID) {
        if (direction != 1 && direction != 2) {
            throw new IllegalArgumentException("Direction of hit must be FORWARD or REVERSE");
        }
        this.direction = direction;
        this.contaminant = contaminant;
        this.length = length;
        this.percentID = percentID;
    }

    public Contaminant contaminant() {
        return this.contaminant;
    }

    public int direction() {
        return this.direction;
    }

    public int length() {
        return this.length;
    }

    public int percentID() {
        return this.percentID;
    }

    public String toString() {
        return String.valueOf(this.contaminant.name()) + " (" + this.percentID + "% over " + this.length + "bp)";
    }
}

