/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence;

import java.io.File;
import java.io.IOException;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Sequence.SequenceFactory;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;
import uk.ac.babraham.FastQC.Utilities.CasavaBasename;
import uk.ac.babraham.FastQC.Utilities.NameFormatException;

public class SequenceFileGroup
implements SequenceFile {
    private File[] files;
    private SequenceFile sequenceFile;
    private File groupFile;
    private int currentIndex = 0;

    public SequenceFileGroup(File[] files) throws IOException, SequenceFormatException {
        this.files = files;
        this.sequenceFile = SequenceFactory.getSequenceFile(files[0]);
        try {
            String baseName = CasavaBasename.getCasavaBasename(this.sequenceFile.name());
            this.groupFile = this.sequenceFile.getFile().getParent() == null ? new File(baseName) : new File(String.valueOf(this.sequenceFile.getFile().getParent()) + "/" + baseName);
        }
        catch (NameFormatException nfe) {
            this.groupFile = this.sequenceFile.getFile();
        }
    }

    public File getFile() {
        return this.groupFile;
    }

    public int getPercentComplete() {
        return 100 * this.currentIndex / this.files.length + this.sequenceFile.getPercentComplete() / this.files.length;
    }

    public boolean hasNext() {
        if (this.sequenceFile.hasNext()) {
            return true;
        }
        if (this.currentIndex < this.files.length - 1) {
            ++this.currentIndex;
            try {
                this.sequenceFile = SequenceFactory.getSequenceFile(this.files[this.currentIndex]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.sequenceFile.hasNext();
    }

    public boolean isColorspace() {
        return this.sequenceFile.isColorspace();
    }

    public String name() {
        return this.groupFile.getName();
    }

    public Sequence next() throws SequenceFormatException {
        return this.sequenceFile.next();
    }
}

