/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Utilities;

import java.awt.Color;
import uk.ac.babraham.FastQC.Utilities.RGB;

public class HotColdColourGradient {
    private final Color[] colors = this.makeColors();

    public String toString() {
        return "Hot Cold Colour Gradient";
    }

    protected Color[] makeColors() {
        Color[] colors = new Color[100];
        double min = 0.0 - Math.pow(50.0, 0.5);
        double max = Math.pow(49.0, 0.5);
        int c = 0;
        while (c < 100) {
            int actualC = c - 50;
            if (actualC < 0) {
                actualC = 0 - actualC;
            }
            double corrected = Math.pow(actualC, 0.5);
            if (c < 50 && corrected > 0.0) {
                corrected = 0.0 - corrected;
            }
            RGB r = this.getRGB(corrected, min, max);
            colors[c] = new Color(r.r, r.g, r.b);
            ++c;
        }
        return colors;
    }

    public Color getColor(double value, double min, double max) {
        int percentage;
        if (this.colors[0] == null) {
            this.makeColors();
        }
        if ((percentage = (int)(100.0 * (value - min) / (max - min))) > 100) {
            percentage = 100;
        }
        if (percentage < 1) {
            percentage = 1;
        }
        return this.colors[percentage - 1];
    }

    private RGB getRGB(double value, double min, double max) {
        int green;
        int blue;
        int red;
        double diff = max - min;
        if (value < min + diff * 0.25) {
            red = 0;
            blue = 200;
            green = (int)(200.0 * ((value - min) / (diff * 0.25)));
        } else if (value < min + diff * 0.5) {
            red = 0;
            green = 200;
            blue = (int)(200.0 - 200.0 * ((value - (min + diff * 0.25)) / (diff * 0.25)));
        } else if (value < min + diff * 0.75) {
            green = 200;
            blue = 0;
            red = (int)(200.0 * ((value - (min + diff * 0.5)) / (diff * 0.25)));
        } else {
            red = 200;
            blue = 0;
            green = (int)(200.0 - 200.0 * ((value - (min + diff * 0.75)) / (diff * 0.25)));
        }
        return new RGB(red, green, blue);
    }
}

