/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaderElection
implements Election {
    private static final Logger LOG = Logger.getLogger(LeaderElection.class);
    protected static Random epochGen = new Random();
    protected QuorumPeer self;

    public LeaderElection(QuorumPeer self) {
        this.self = self;
    }

    protected ElectionResult countVotes(HashMap<InetSocketAddress, Vote> votes, HashSet<Long> heardFrom) {
        ElectionResult result = new ElectionResult();
        result.vote = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        result.winner = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        Collection<Vote> votesCast = votes.values();
        Iterator<Vote> i = votesCast.iterator();
        while (i.hasNext()) {
            Vote v = i.next();
            if (!heardFrom.contains(v.id)) {
                i.remove();
                continue;
            }
            for (Vote w : votesCast) {
                if (v.id != w.id || v.zxid >= w.zxid) continue;
                v.zxid = w.zxid;
            }
        }
        HashMap<Vote, Integer> countTable = new HashMap<Vote, Integer>();
        for (Vote vote : votesCast) {
            Integer count = (Integer)countTable.get(vote);
            if (count == null) {
                count = 0;
            }
            countTable.put(vote, count + 1);
            if (vote.id == result.vote.id) {
                ++result.count;
                continue;
            }
            if (vote.zxid <= result.vote.zxid && (vote.zxid != result.vote.zxid || vote.id <= result.vote.id)) continue;
            result.vote = vote;
            result.count = 1;
        }
        result.winningCount = 0;
        LOG.info((Object)"Election tally: ");
        for (Map.Entry entry : countTable.entrySet()) {
            if ((Integer)entry.getValue() > result.winningCount) {
                result.winningCount = (Integer)entry.getValue();
                result.winner = (Vote)entry.getKey();
            }
            LOG.info((Object)(((Vote)entry.getKey()).id + "\t-> " + entry.getValue()));
        }
        return result;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        try {
            this.self.jmxLeaderElectionBean = new LeaderElectionBean();
            MBeanRegistry.getInstance().register(this.self.jmxLeaderElectionBean, this.self.jmxLocalPeerBean);
        }
        catch (Exception e) {
            LeaderElection.LOG.warn((Object)"Failed to register with JMX", (Throwable)e);
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
            requestBytes = new byte[4];
            requestBuffer = ByteBuffer.wrap(requestBytes);
            responseBytes = new byte[28];
            responseBuffer = ByteBuffer.wrap(responseBytes);
            s = null;
            try {
                s = new DatagramSocket();
                s.setSoTimeout(200);
            }
            catch (SocketException e1) {
                LeaderElection.LOG.error((Object)"Socket exception when creating socket for leader election", (Throwable)e1);
                System.exit(4);
            }
            requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
            responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
            votes = new HashMap<InetSocketAddress, Vote>(this.self.getVotingView().size());
            xid = LeaderElection.epochGen.nextInt();
            while (this.self.isRunning()) {
                block30: {
                    block29: {
                        votes.clear();
                        requestBuffer.clear();
                        requestBuffer.putInt(xid);
                        requestPacket.setLength(4);
                        heardFrom = new HashSet<Long>();
                        for (QuorumPeer.QuorumServer server : this.self.getVotingView().values()) {
                            LeaderElection.LOG.info((Object)("Server address: " + server.addr));
                            try {
                                requestPacket.setSocketAddress(server.addr);
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + server.addr, e);
                            }
                            try {
                                s.send(requestPacket);
                                responsePacket.setLength(responseBytes.length);
                                s.receive(responsePacket);
                                if (responsePacket.getLength() != responseBytes.length) {
                                    LeaderElection.LOG.error((Object)("Got a short response: " + responsePacket.getLength()));
                                    continue;
                                }
                                responseBuffer.clear();
                                recvedXid = responseBuffer.getInt();
                                if (recvedXid != xid) {
                                    LeaderElection.LOG.error((Object)("Got bad xid: expected " + xid + " got " + recvedXid));
                                    continue;
                                }
                                peerId = responseBuffer.getLong();
                                heardFrom.add(peerId);
                                vote = new Vote(responseBuffer.getLong(), responseBuffer.getLong());
                                addr = (InetSocketAddress)responsePacket.getSocketAddress();
                                votes.put(addr, vote);
                            }
                            catch (IOException e) {
                                LeaderElection.LOG.warn((Object)"Ignoring exception while looking for leader", (Throwable)e);
                            }
                        }
                        result = this.countVotes(votes, heardFrom);
                        if (votes.size() != 0) break block29;
                        this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
                        break block30;
                    }
                    if (result.winner.id < 0L) break block30;
                    this.self.setCurrentVote(result.vote);
                    if (result.winningCount <= this.self.getVotingView().size() / 2) break block30;
                    this.self.setCurrentVote(result.winner);
                    s.close();
                    current = this.self.getCurrentVote();
                    LeaderElection.LOG.info((Object)("Found leader: my type is: " + (Object)this.self.getPeerType()));
                    if (this.self.getPeerType() != QuorumPeer.LearnerType.OBSERVER) ** GOTO lbl86
                    if (current.id == this.self.getId()) {
                        LeaderElection.LOG.error((Object)"OBSERVER elected as leader!");
                        Thread.sleep(100L);
                    } else {
                        this.self.setPeerState(QuorumPeer.ServerState.OBSERVING);
                        Thread.sleep(100L);
                        var13_19 = current;
                        return var13_19;
lbl86:
                        // 1 sources

                        this.self.setPeerState(current.id == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        if (this.self.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                            Thread.sleep(100L);
                        }
                        var13_20 = current;
                        return var13_20;
                    }
                }
                Thread.sleep(1000L);
            }
            var10_12 = null;
            return var10_12;
        }
        finally {
            try {
                if (this.self.jmxLeaderElectionBean != null) {
                    MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                }
            }
            catch (Exception e) {
                LeaderElection.LOG.warn((Object)"Failed to unregister with JMX", (Throwable)e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
    }

    public static class ElectionResult {
        public Vote vote;
        public int count;
        public Vote winner;
        public int winningCount;
    }
}

