/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.Alphabet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Alphabets {
    private static final Set<Character> AMBIGUOUS_DNA_ALPHABET_LETTERS = Alphabets.toUnmodifiableSet(new char[]{'G', 'A', 'T', 'C', 'R', 'Y', 'W', 'S', 'M', 'K', 'H', 'B', 'V', 'D', 'N'});
    private static final Set<Character> UNAMBIGUOUS_DNA_ALPHABET_LETTERS = Alphabets.toUnmodifiableSet(new char[]{'G', 'A', 'T', 'C'});
    private static final Set<Character> AMBIGUOUS_RNA_ALPHABET_LETTERS = Alphabets.toUnmodifiableSet(new char[]{'G', 'A', 'U', 'C', 'R', 'Y', 'W', 'S', 'M', 'K', 'H', 'B', 'V', 'D', 'N'});
    private static final Set<Character> UNAMBIGUOUS_RNA_ALPHABET_LETTERS = Alphabets.toUnmodifiableSet(new char[]{'G', 'A', 'U', 'C'});
    private static final Set<Character> READ_DNA_ALPHABET_LETTERS = Alphabets.toUnmodifiableSet(new char[]{'G', 'A', 'T', 'C', 'N'});
    public static final Alphabet AMBIGUOUS_DNA_ALPHABET = new Alphabet(){

        @Override
        public final String getName() {
            return "AmbiguousDNA";
        }

        @Override
        public final Set<Character> getLetters() {
            return AMBIGUOUS_DNA_ALPHABET_LETTERS;
        }

        @Override
        protected final boolean isLowerCaseValid() {
            return true;
        }

        @Override
        protected final char getComplement(char letter) {
            switch (letter) {
                case 'A': {
                    return 'T';
                }
                case 'C': {
                    return 'G';
                }
                case 'G': {
                    return 'C';
                }
                case 'T': {
                    return 'A';
                }
                case 'M': {
                    return 'K';
                }
                case 'R': {
                    return 'Y';
                }
                case 'W': {
                    return 'W';
                }
                case 'S': {
                    return 'S';
                }
                case 'Y': {
                    return 'R';
                }
                case 'K': {
                    return 'M';
                }
                case 'V': {
                    return 'B';
                }
                case 'H': {
                    return 'D';
                }
                case 'D': {
                    return 'H';
                }
                case 'B': {
                    return 'V';
                }
                case 'X': {
                    return 'X';
                }
                case 'N': {
                    return 'N';
                }
                case 'a': {
                    return 't';
                }
                case 'c': {
                    return 'g';
                }
                case 'g': {
                    return 'c';
                }
                case 't': {
                    return 'a';
                }
                case 'm': {
                    return 'k';
                }
                case 'r': {
                    return 'y';
                }
                case 'w': {
                    return 'w';
                }
                case 's': {
                    return 's';
                }
                case 'y': {
                    return 'r';
                }
                case 'k': {
                    return 'm';
                }
                case 'v': {
                    return 'b';
                }
                case 'h': {
                    return 'd';
                }
                case 'd': {
                    return 'h';
                }
                case 'b': {
                    return 'v';
                }
                case 'x': {
                    return 'x';
                }
                case 'n': {
                    return 'n';
                }
            }
            return letter;
        }
    };
    public static final Alphabet UNAMBIGUOUS_DNA_ALPHABET = new Alphabet(){

        @Override
        public final String getName() {
            return "UnAmbiguousDNA";
        }

        @Override
        public final Set<Character> getLetters() {
            return UNAMBIGUOUS_DNA_ALPHABET_LETTERS;
        }

        @Override
        protected final boolean isLowerCaseValid() {
            return true;
        }

        @Override
        protected final char getComplement(char letter) {
            switch (letter) {
                case 'A': {
                    return 'T';
                }
                case 'C': {
                    return 'G';
                }
                case 'G': {
                    return 'C';
                }
                case 'T': {
                    return 'A';
                }
                case 'a': {
                    return 't';
                }
                case 'c': {
                    return 'g';
                }
                case 'g': {
                    return 'c';
                }
                case 't': {
                    return 'a';
                }
            }
            return letter;
        }
    };
    public static final Alphabet AMBIGUOUS_RNA_ALPHABET = new Alphabet(){

        @Override
        public final String getName() {
            return "AmbiguousRNA";
        }

        @Override
        public final Set<Character> getLetters() {
            return AMBIGUOUS_RNA_ALPHABET_LETTERS;
        }

        @Override
        protected final boolean isLowerCaseValid() {
            return true;
        }

        @Override
        protected final char getComplement(char letter) {
            switch (letter) {
                case 'A': {
                    return 'U';
                }
                case 'C': {
                    return 'G';
                }
                case 'G': {
                    return 'C';
                }
                case 'U': {
                    return 'A';
                }
                case 'M': {
                    return 'K';
                }
                case 'R': {
                    return 'Y';
                }
                case 'W': {
                    return 'W';
                }
                case 'S': {
                    return 'S';
                }
                case 'Y': {
                    return 'R';
                }
                case 'K': {
                    return 'M';
                }
                case 'V': {
                    return 'B';
                }
                case 'H': {
                    return 'D';
                }
                case 'D': {
                    return 'H';
                }
                case 'B': {
                    return 'V';
                }
                case 'X': {
                    return 'X';
                }
                case 'N': {
                    return 'N';
                }
                case 'a': {
                    return 'u';
                }
                case 'c': {
                    return 'g';
                }
                case 'g': {
                    return 'c';
                }
                case 'u': {
                    return 'a';
                }
                case 'm': {
                    return 'k';
                }
                case 'r': {
                    return 'y';
                }
                case 'w': {
                    return 'w';
                }
                case 's': {
                    return 's';
                }
                case 'y': {
                    return 'r';
                }
                case 'k': {
                    return 'm';
                }
                case 'v': {
                    return 'b';
                }
                case 'h': {
                    return 'd';
                }
                case 'd': {
                    return 'h';
                }
                case 'b': {
                    return 'v';
                }
                case 'x': {
                    return 'x';
                }
                case 'n': {
                    return 'n';
                }
            }
            return letter;
        }
    };
    public static final Alphabet UNAMBIGUOUS_RNA_ALPHABET = new Alphabet(){

        @Override
        public final String getName() {
            return "UnAmbiguousRNA";
        }

        @Override
        public final Set<Character> getLetters() {
            return UNAMBIGUOUS_RNA_ALPHABET_LETTERS;
        }

        @Override
        protected final boolean isLowerCaseValid() {
            return true;
        }

        @Override
        protected final char getComplement(char letter) {
            switch (letter) {
                case 'A': {
                    return 'U';
                }
                case 'C': {
                    return 'G';
                }
                case 'G': {
                    return 'C';
                }
                case 'U': {
                    return 'A';
                }
                case 'a': {
                    return 'u';
                }
                case 'c': {
                    return 'g';
                }
                case 'g': {
                    return 'c';
                }
                case 'u': {
                    return 'a';
                }
            }
            return letter;
        }
    };
    public static final Alphabet READ_DNA_ALPHABET = new Alphabet(){

        @Override
        public final String getName() {
            return "ReadDNA";
        }

        @Override
        public final Set<Character> getLetters() {
            return READ_DNA_ALPHABET_LETTERS;
        }

        @Override
        protected final boolean isLowerCaseValid() {
            return false;
        }

        @Override
        protected final char getComplement(char letter) {
            switch (letter) {
                case 'A': {
                    return 'T';
                }
                case 'C': {
                    return 'G';
                }
                case 'G': {
                    return 'C';
                }
                case 'T': {
                    return 'A';
                }
                case 'N': {
                    return 'N';
                }
            }
            return letter;
        }

        @Override
        public final boolean isLetterValid(char letter) {
            switch (letter) {
                case 'A': 
                case 'C': 
                case 'G': 
                case 'N': 
                case 'T': {
                    return true;
                }
            }
            return false;
        }
    };

    private static Set<Character> toUnmodifiableSet(char[] array) {
        if (array == null) {
            return null;
        }
        HashSet<Character> result = new HashSet<Character>();
        for (char c : array) {
            result.add(Character.valueOf(c));
        }
        return Collections.unmodifiableSet(result);
    }
}

